/*
* Version 2.10i
* (c) Copyright 2002-2004, Deagles
* (c) Copyright for original Mapchooser by OLO
* This file is provided as is, with absolutely no warranty.
* You may not edit this file for re-publishing without explicet permission
* from Deagles or OLO
* This is the final "official" version of this plugin to be released.
* AMXX Version ONLY!
*/

#include <amxmodx>
#include <amxmisc>
#define MAX_MAPS_AMOUNT 128

new maps_to_select, isbuytime=0, isbetween=0
new ban_last_maps=0, quiet=0
new Float:rtvpercent,Float:thespeed,Float:oldtimelimit
new minimum=1, minimumwait=10, enabled=1,cycle=0,dofreeze=1, maxnom=3, maxcustnom=5,  frequency=3,oldwinlimit=0, addthiswait=0
new mapsurl[64], amt_custom=0
new isend=0, isspeedset=0, istimeset=0,iswinlimitset=0,istimeset2=0,mapssave=0,atstart
new usestandard=1, currentplayers=0,activeplayers=0, counttovote=0, countnum=0
new inprogress=0, rocks=0, rocked[32], hasbeenrocked=0, waited=0
new pathtomaps[64]
new nmaps[MAX_MAPS_AMOUNT][32]
new listofmaps[MAX_MAPS_AMOUNT][32]
new totalbanned=0
new banthesemaps[MAX_MAPS_AMOUNT][32]
new totalmaps=0
new lastmaps[100+1][32]
new bannedsofar=0
new standard[50][32]
new standardtotal=0
new nmaps_num=0
new nbeforefill
new nmapsfill[MAX_MAPS_AMOUNT][32]
new num_nmapsfill
new nnextmaps[10], nvotes[12], nmapstoch, before_num_nmapsfill=0, bool:mselected = false
new teamscore[2], last_map[32]
new Nominated[MAX_MAPS_AMOUNT]
new whonmaps_num[MAX_MAPS_AMOUNT]

// Added by Monolyth
new maptypes[5][] = {"cs","de","as","dod","fy"}
new maptypecount = 5
new storedfreezetime = 0

forward public hudtext16(textblock[],colr,colg,colb,posx,posy,screen,time,id);
forward bool:isbanned(map[]);
forward bool:iscustommap(map[]);
forward bool:islastmaps(map[]);
forward bool:isnominated(map[]);
forward public handle_nominate(id,map[]);
forward available_maps();
forward public getready();
forward public timetovote();
forward public messagefifteen();
forward public messagenominated();
forward public messagemaps();
forward public stopperson()
forward public countdown();
forward public rock_it_now();
forward public timedisplay();
forward public messagethree();

public client_connect(id)
{
        currentplayers++
}


public loopmessages()
{
        if(quiet==2)
        {
                return PLUGIN_HANDLED
        }
        else
        {
                new timeleft = get_timeleft()
                new partialtime=timeleft%370
                new maintime=timeleft%600

                if((maintime>122&&maintime<128)&&timeleft>114)
                {
                        set_task(1.0,"timedisplay",454510,"",0,"a",5)
                }

                if((partialtime>320&&partialtime<326)&&!cycle)
                {
                        set_task(3.0,"messagethree",987300)//,"",0,"a",4)
                        return PLUGIN_HANDLED
                }
                
        }
        
        return PLUGIN_HANDLED
}


public timedisplay()
{
        new timeleft=get_timeleft()
        new seconds=timeleft%60
        new minutes=floatround((timeleft-seconds)/60.0)
        
        if(timeleft<1)
        {
                remove_task(454510)
                remove_task(454500)
                remove_task(123452)
                remove_task(123499)
                return PLUGIN_HANDLED
        }
        
        if(timeleft>140)
        {
                remove_task(454500)
        }
        
        if(timeleft>30)
        {
                set_hudmessage(255,255,220, 0.02, 0.2, 0, 1.0, 1.04, 0.0, 0.05, 3)
        }
        else
        {
                set_hudmessage(210,0 ,0, 0.02, 0.15, 0, 1.0, 1.04, 0.0, 0.05, 3)
                show_hudmessage(0,"Time Left^n%d:%02d", minutes,seconds)
        }
        
        if(timeleft<70 && (timeleft%5)==1 )
        {
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                set_hudmessage(0,132,255, 0.02, 0.27, 0, 5.0, 5.04, 0.0, 0.5, 8)
                show_hudmessage(0,"Nextmap: %s",smap)
                
        }
        
        return PLUGIN_HANDLED
}


public messagethree()
{
        new timeleft = get_timeleft()
        new time2=timeleft-timeleft%60
        new minutesleft=floatround(float(time2)/60.0)
        new mapname[32]
        get_mapname(mapname,31)
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        
        if(minutesleft>=2&&!mselected)
        {
                client_print(0,print_chat, "%L", LANG_PLAYER, "VOTE_WILL_OCCUR_IN",(minutesleft==3||minutesleft==2)?timeleft-100:minutesleft-2,(minutesleft==3||minutesleft==2)?"seconds":"minutes")
        }
        else
        {
                if(mselected)
                {
                        client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_FIN_CHANGE_IN", smap, timeleft)
                }
                else
                {
                        if(minutesleft<=2&&timeleft)
                        {
                                client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_IN_PROG_CURRENT", mapname)
                        }
                }
        }
        
}


public client_putinserver(id)
{
        activeplayers++
}

public client_disconnect(id)
{
        remove_task(987600+id)
        remove_task(127600+id)
        currentplayers--
        activeplayers--
        
        if(rocked[id])
        {
                rocked[id]=0
                rocks--
        }
        
        if(get_timeleft()>160)
        {
                if(!mselected&&!hasbeenrocked&&!inprogress)
                {
                        check_if_need()
                }
                
                new kName[32]
                get_user_name(id,kName,31)
                new n=0

                while(Nominated[id]>0&&n<nmaps_num)
                {
                        if(whonmaps_num[n]==id)
                        {
                                if(get_timeleft()>50&&quiet!=2)
                                {
                                        client_print(0,print_chat,"%L", LANG_PLAYER, "PLAYER_LEFT_NO_NM",kName,nmaps[n])
                                        log_amx("%L", LANG_SERVER, "LOG_AMX_PLYR_NO_NM", kName,nmaps[n])
                                }
                                        
                                new j=n
                                while(j<nmaps_num-1)
                                {
                                        whonmaps_num[j]=whonmaps_num[j+1]
                                        nmaps[j]=nmaps[j+1]
                                        j++
                                }

                                nmaps_num--
                                Nominated[id]=Nominated[id]-1
                        }
                        else
                        {
                                n++
                        }
                }
        }
        
        return PLUGIN_CONTINUE
}


public list_maps(id)
{
        new m
        new idreal=id
        new iteration=0

        client_print(id,print_chat, "%L", id, "MAPLIST_CONSOLE", totalmaps)

        if(totalmaps-(50*iteration)>=50)
        {
                client_print(idreal,print_console, "[ ************ Maps %d - %d :***********",iteration*50+1,iteration*50 + (50))
        }
        else
        {
                client_print(idreal,print_console, "[ ************ Maps %d - %d :***********",iteration*50+1,iteration*50 + (totalmaps-iteration*50) )
        }

        for(m=50*iteration;(m<totalmaps&&m<50*(iteration+1));m+=3)
        {
                if(m+1<totalmaps)
                {
                        if(m+2<totalmaps)
                        {
	                        	console_print(id," ]")
                                console_print(id,"   %s   %s   %s",listofmaps[m],listofmaps[m+1],listofmaps[m+2])
                        }
                        else
                        {
                                console_print(id,"   %s   %s",listofmaps[m],listofmaps[m+1])
                        }
                }
                else
                {
                        console_print(id,"   %s",listofmaps[m])
                }

                if(50*(iteration+1)<totalmaps)
                {
                        new kIdfake[32]
                        num_to_str((id+50*(iteration+1)),kIdfake,6)
                        client_print(idreal, print_console, "%L", idreal, "MAPLIST_CONSOLE_MORE")
                        set_task(4.0,"more_list_maps",127600+id,kIdfake,6)
                }
        }

        return PLUGIN_CONTINUE
}


public more_list_maps(idfakestr[])
{
        new idfake=str_to_num(idfakestr)
        new m
        new idreal=idfake
        new iteration=0

        while(idreal>=50)
        {
                idreal-=50
                iteration++
        }

        if(totalmaps-(50*iteration)>=50)
        {
                client_print(idreal,print_console, "[ ************ Maps %d - %d :***********",iteration*50+1,iteration*50 + (50))
        }
        else
        {
                client_print(idreal,print_console, "[ ************ Maps %d - %d :***********",iteration*50+1,iteration*50 + (totalmaps-iteration*50) )
        }

        for(m=50*iteration;(m<totalmaps&&m<50*(iteration+1));m+=3)
        {
                if(m+1<totalmaps)
                {
                        if(m+2<totalmaps)
                        {
								console_print(idreal," ]")
                                console_print(idreal,"   %s   %s   %s",listofmaps[m],listofmaps[m+1],listofmaps[m+2])
                        }
                        else
                        {
                                console_print(idreal,"   %s   %s",listofmaps[m],listofmaps[m+1])
                        }
                }
                else
                {
                        console_print(idreal,"   %s",listofmaps[m])
                }
        }
        
        if(50*(iteration+1)<totalmaps)
        {
                new kIdfake[32]
                num_to_str((idreal+50*(iteration+1)),kIdfake,6)
                client_print(idreal, print_console, "%L", idreal, "MAPLIST_CONSOLE_MORE")
                set_task(2.0,"more_list_maps",127600+idreal,kIdfake,6)
        }
        else
        {
                client_print(idreal, print_console,"%L", idreal, "MAPLIST_CONSOLE_FIN", totalmaps)
        }
}


public say_nextmap(id)
{
        new timeleft = get_timeleft()
        new time2=timeleft-timeleft%60
        new minutesleft=floatround(float(time2)/60.0)
        new mapname[32]
        get_mapname(mapname,31)
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        
        if(minutesleft>=2&&!mselected)
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_OCCUR_IN_NOM", (minutesleft==3||minutesleft==2)?timeleft-100:minutesleft-2,(minutesleft==3||minutesleft==2)?"sec.":"min.")
        }
        else
        {
                if(mselected)
                {
                        client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_FIN_CHANGE_IN", smap, timeleft)
                }
                else
                {
                        if(inprogress)
                        {
                                client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_IN_PROG_CURRENT", mapname)
                        }
                }
        }
        
        return PLUGIN_HANDLED
}


public check_if_need()
{
        new Float:ratio=rtvpercent
        new needed=floatround(float(activeplayers)*ratio+0.49)
        new timeleft = get_timeleft()
        new Float:minutesleft=float(timeleft)/60.0
        new Float:currentlimit=get_cvar_float("mp_timelimit")
        new Float:minutesplayed=currentlimit-minutesleft
        new wait
        wait=minimumwait

        if((minutesplayed+0.5)>=(float(wait)))
        {
                if(rocks>=needed&&rocks>=minimum)
                {
                        client_print(0,print_chat,"%L", LANG_PLAYER, "RTV_ENOUGH_VOTE_SHORT",rocks)
                        set_hudmessage(222, 70,0, -1.0, 0.3, 1, 10.0, 10.0, 2.0, 4.0, 8)
                        show_hudmessage(0, "%L", LANG_PLAYER, "RTV_ENOUGH_VOTE_HUD", rocks )
                        hasbeenrocked=1
                        inprogress=1
                        mselected=false
                        set_task(15.0, "rock_it_now",765100)
                }
        }
}


public rock_the_vote(id)
{
        new Float:ratio=rtvpercent
        new needed=floatround(float(activeplayers)*ratio+0.49)
        new kName[32]
        get_user_name(id,kName,31)
        new timeleft = get_timeleft()
        new Float:minutesleft=float(timeleft)/60.0
        new Float:currentlimit=get_cvar_float("mp_timelimit")
        new Float:minutesplayed=currentlimit-minutesleft
        new wait
        wait=minimumwait
        if(cycle)
        {
                client_print(id,print_chat,"%L", id, "VOTE_DISABLED_SERVER")
                return PLUGIN_CONTINUE
        }
        
        if(!enabled)
        {
                client_print(id,print_chat,"%L", id, "RTV_DISABLED_SERVER")
                return PLUGIN_CONTINUE
        }
        
        if(inprogress)
        {
                client_print(id,print_chat,"%L", id, "VOTE_INPROG_ORBEGIN")
                return PLUGIN_CONTINUE
        }

        if(mselected)
        {
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                client_print(id,print_chat, "%L", id, "VOTING_COMPLETE",smap,get_timeleft())
                return PLUGIN_CONTINUE
        }
        
        if(hasbeenrocked)
        {
                client_print(id,print_chat,"%L", id, "VOTING_ALREADY_ROCK",kName)
                return PLUGIN_CONTINUE
        }

        if(timeleft<120)
        {
                if(timeleft>1)
                {
                        client_print(id,print_chat,"%L", id, "RTV_NOT_ENOUGHT_TIME")
                }
                else
                {
                        client_print(id,print_chat,"%L", id, "RTV_NO_TIMELIMIT")
                }
                return PLUGIN_CONTINUE
        }

        if((minutesplayed+0.5)<(float(wait)))
        {
                if(float(wait)-0.5-minutesplayed>0.0)
                {
                        client_print(id,print_chat,"%L", id, "RTV_WAIT_UNTIL",kName,(floatround(float(wait)+0.5-minutesplayed)>0)?(floatround(float(wait)+0.5-minutesplayed)):(1))
                }
                else
                {
                        client_print(id,print_chat,"%L", id, "RTV_WAIT_UNMIN")
                }
                
                if((get_user_flags(id)&ADMIN_MAP))
                {
                        console_print(id,"%L", id, "RTV_ADMIN_MAYFORCE",kName)
                }

                return PLUGIN_CONTINUE
        }

        if(!rocked[id])
        {
                rocked[id]=1
                rocks++
        }
        else
        {
                client_print(id,print_chat,"%L", id, "RTV_NO_ROCK_TWICE",kName)
                return PLUGIN_CONTINUE
        }

        if(rocks>=needed&&rocks>=minimum)
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "RTV_ENOUGH_VOTE_SHORT",rocks)
                set_hudmessage(222, 70,0, -1.0, 0.3, 1, 10.0, 10.0, 2.0, 4.0, 8)
                show_hudmessage(0,"%L", LANG_PLAYER, "RTV_ENOUGH_VOTE_HUD",rocks )
                hasbeenrocked=1
                inprogress=1
                mselected=false
                set_task(15.0, "rock_it_now",765100)
        }
        else
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "RTV_MORE_PLAYERS",((needed-rocks)>(minimum-needed))?(needed-rocks):(minimum-rocks))
        }
        
        return PLUGIN_CONTINUE
}


public rock_it_now()
{
        new temprocked=hasbeenrocked
        hasbeenrocked=1
        new timeleft = get_timeleft()
        new Float:minutesleft=float(timeleft)/60.0
        new Float:currentlimit=get_cvar_float("mp_timelimit")
        new Float:minutesplayed=currentlimit-minutesleft
        new Float:timelimit
        counttovote=0
        remove_task(459200)
        remove_task(459100)
        timelimit=float(floatround(minutesplayed+1.5))
        
        if(timelimit>0.4)
        {
                oldtimelimit=get_cvar_float("mp_timelimit")
                istimeset=1
                set_cvar_float("mp_timelimit", timelimit)
                
                if(quiet!=2)
                {
                        console_print(0,"%L", LANG_PLAYER, "CONSOLE_TLIMIT_CHG",
                        floatround(get_cvar_float("mp_timelimit")))
                        log_amx("%L", LANG_SERVER, "LOG_AMX_CON_TL_CHG",
                        floatround(get_cvar_float("mp_timelimit")))
                }
        }
        else
        {
                console_print(0,"%L", LANG_PLAYER, "UNABLE_CHG_TLIMIT_NRCK")
                log_amx("%L", LANG_SERVER, "LOG_AMX_UN_CHG_TL_NRCK",floatround(timelimit),timeleft)
                new inum,players[32],i
                get_players(players,inum,"c")
                
                for(i = 0 ;i < inum; ++i)
                {
                        rocked[i]=0
                }

                rocks=0
                hasbeenrocked=temprocked
                return PLUGIN_HANDLED
        }
        
        timeleft=get_timeleft()
        inprogress=1
        mselected=false

        if(quiet!=2)
        {
                set_hudmessage(0, 222,50, -1.0, 0.23, 1, 6.0, 6.0, 1.0, 1.0, 8)
                show_hudmessage(0,"%L", LANG_PLAYER, "ATTN_VOTE_BEGIN_HUD")
        }
        else
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "MAP_VOTE_BEGIN_TENSEC")
                if(quiet==0)
                {
                        client_cmd(0,"spk ^"get red(e80) ninety(s45) to check(e20) use _comma(e10) bay(s18) mass(e42) cap(s50)^"")
                }
        }
                
        set_task(3.5,"getready",459100)
        set_task(10.0,"startthevote")
        remove_task(454500)
        remove_task(123452)
        rocks=0
        new inum,players[32],i
        get_players(players,inum,"c")

        for(i = 0 ;i < inum; ++i)
        {
                rocked[i]=0
        }
        set_task(2.18,"calculate_custom")
        
        return PLUGIN_HANDLED
}

public admin_rockit(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }
        
        new arg[32]
        read_argv(1,arg,31)
        new kName[32], timeleft=get_timeleft()
        get_user_name(id,kName,31)

        if(timeleft<180.0)
        {
                console_print(id, "%L", id, "RTV_NOT_ENOUGHT_TIME")
                return PLUGIN_HANDLED
        }
        
        if(inprogress||hasbeenrocked||isend)
        {
                console_print(id,"%L", id, "VOTE_PROG_BEG_OVER_ROCK")
                return PLUGIN_HANDLED
        }

        if(cycle)
        {
                console_print(id,"%L", id, "CYCLE_MODE_ENABLE_TO_CHNG")
                return PLUGIN_HANDLED
        }

        if(!mselected)
        {
                switch(get_cvar_num("amx_show_activity"))
                {
                        case 2:   client_print(0,print_chat,"%L", LANG_PLAYER, "ACT2_ADMIN_RTV",kName)
                        case 1:   client_print(0,print_chat,"%L", LANG_PLAYER, "ACT1_ADMIN_RTV")
                }
        }
        else
        {
                switch(get_cvar_num("amx_show_activity"))
                {
                        case 2:   client_print(0,print_chat,"%L", LANG_PLAYER, "ACT2_ADMIN_REVOTE",kName)
                        case 1:   client_print(0,print_chat,"%L", LANG_PLAYER, "ACT1_ADMIN_REVOTE")
                }
        }
        
        remove_task(123450)
        remove_task(123400)
        remove_task(123452)
        remove_task(123499)
        counttovote=0
        remove_task(459200)
        remove_task(459100)
        log_amx("%L", LANG_SERVER, "LOG_AMX_ADMIN_RTV", kName,timeleft)
        inprogress=1
        mselected=false
        set_task(15.0, "rock_it_now",765100)
        set_task(0.18,"calculate_custom")
        return PLUGIN_HANDLED
}

public check_votes()
{
        new timeleft=get_timeleft()
        new b = 0 ,a

        for(a= 0; a < nmapstoch; ++a)
        {
                if (nvotes[b] < nvotes[a])
                {
                        b = a
                }
        }

        if ( nvotes[maps_to_select] > nvotes[b] )
        {
                new mapname[32]
                get_mapname(mapname,31)
                new Float:steptime = get_cvar_float("amx_extendmap_step")
                set_cvar_float("mp_timelimit", get_cvar_float("mp_timelimit") + steptime )
                istimeset=1

                if(quiet!=2)
                {
                        set_hudmessage(222, 70,0, -1.0, 0.4, 0, 4.0, 10.0, 2.0, 2.0, 8)
                        show_hudmessage(0,"%L", LANG_PLAYER, "VOTE_EXTEND_HUD", steptime )
                        if(quiet!=1)
                        {
                                client_cmd(0,"speak ^"barney/waitin^"")
                        }
                }
                
                client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_EXTEND", steptime )
                log_amx("%L", LANG_SERVER, "LOG_AMX_VOTE_EXTEND",
                mapname , steptime )
                inprogress=isend=0
                nmaps_num=nbeforefill
                num_nmapsfill=before_num_nmapsfill
                return PLUGIN_HANDLED
        }

        if ( nvotes[b] && nvotes[maps_to_select+1] <= nvotes[b] )
        {
                set_cvar_string("amx_nextmap", nmaps[nnextmaps[b]] )
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                new players[32], inum
                get_players(players,inum,"c")
                
                if(quiet!=2)
                {
                        set_hudmessage(222, 70,0, -1.0, 0.36, 0, 4.0, 10.0, 2.0, 2.0, 8)
                }
                
                if(timeleft<=0||timeleft>300)
                {
                        show_hudmessage(0,"%L", LANG_PLAYER, "ATTN_MAP_WIN_CHG_RND_END_HUD",nmaps[nnextmaps[b]],nvotes[b],timeleft)
                }
                else
                {
                        if(iscustommap(nmaps[nnextmaps[b]])&&usestandard)
                        {
                                set_hudmessage(0,152,255, -1.0, 0.22, 0, 4.0, 7.0, 2.1, 1.5, 8)
                                show_hudmessage(0,"%L", LANG_PLAYER, "MAP_WIN_CHG_RND_END_HUD",nmaps[nnextmaps[b]],nvotes[b],timeleft)
                                client_print(0,print_notify,"%L", LANG_PLAYER, "CUSTOM_MAP_DL")
                        }
                        else
                        {
                                set_hudmessage(0,152,255, -1.0, 0.22, 0, 4.0, 7.0, 2.1, 1.5, 8)
                                show_hudmessage(0,"%L", LANG_PLAYER, "MAP_WIN_CHG_RND_END_HUD",nmaps[nnextmaps[b]],nvotes[b],timeleft)
                        }

                        if((containi(mapsurl,"www")!=-1||containi(mapsurl,"http")!=-1) &&iscustommap(nmaps[nnextmaps[b]]))
                        {
                                client_print(0,print_chat,"%L", LANG_PLAYER, "CUSTOM_MAP_DL_LOC",mapsurl)
                        }

                        if(quiet!=1)
                        {
                                client_cmd(0,"speak ^"barney/letsgo^"")
                        }
                }
        }
        
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        client_print(0,print_chat,"%L", LANG_PLAYER, "CHOOSE_FIN_NEXTMAP", smap )
        log_amx("%L", LANG_SERVER, "LOG_AMX_CHOOSE_FIN_NEXTMAP", smap)
        inprogress=waited=0
        isend=1
        new waituntilready=timeleft-60

        if(waituntilready>30)
        {
                waituntilready=30
        }

        if(waituntilready<=0||get_cvar_num("mp_winlimit"))
        {
                addthiswait=4
                set_task(4.0,"RoundMode",333333)
        }
        else
        {
                set_task(float(waituntilready),"RoundMode",333333)
                addthiswait=waituntilready
        }
        
        nmaps_num=nbeforefill
        num_nmapsfill=before_num_nmapsfill
        set_task(2.18,"calculate_custom")
        return PLUGIN_HANDLED
}


public show_timer()
{
        set_task(1.0,"timedis2",454500,"",0,"b")
}


public timedis2()
{
        new timeleft=get_timeleft()
        
        if((timeleft%5)==1 )
        {
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                set_hudmessage(0,132,255, 0.02, 0.27, 0, 5.0, 5.04, 0.0, 0.5, 8)
                show_hudmessage(0,"Next map: %s",smap)
                
                if(waited<90)
                {
                        set_hudmessage(255,215,190, 0.02, 0.2, 0, 5.0, 5.04, 0.0, 0.5, 3)
                }
                else
                {
                        set_hudmessage(210,0 ,0, 0.02, 0.15, 0, 5.0, 5.04, 0.0, 0.5, 3)
                }
                
                show_hudmessage(0,"Last Round")
                
                if(dofreeze)
                {
                        new endmapfrozentime=15
                        storedfreezetime = get_cvar_num("mp_freezetime")
                        set_cvar_num("mp_freezetime", endmapfrozentime)
                }
        }
        return PLUGIN_HANDLED
}


public timedis3()
{
        new timeleft=get_timeleft()
        
        if((timeleft%5)==1 )
        {
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                set_hudmessage(0,132,255, 0.02, 0.27, 0, 5.0, 5.04, 0.0, 0.5, 8)
                show_hudmessage(0,"Next map: %s",smap)
                
                if(timeleft>30)
                {
                        set_hudmessage(255,215,190, 0.02, 0.2, 0, 5.0, 5.04, 0.0, 0.5, 3)
                }
                else
                {
                      set_hudmessage(210,0 ,0, 0.02, 0.15, 0, 5.0, 5.04, 0.0, 0.5, 3)
                }
        
                new seconds=timeleft%60
                new minutes=floatround((timeleft-seconds)/60.0)
                show_hudmessage(0,"Time Left^n%d:%02d", minutes,seconds)
        }
        
        return PLUGIN_HANDLED
}


public RoundMode()
{
        if(get_cvar_float("mp_timelimit")>0.1 && get_cvar_num("enforce_timelimit"))
        {
                remove_task(333333)
                remove_task(454500)
                new timeleft=get_timeleft()
                
                if(timeleft<200)
                {
                        set_task(float(timeleft)-5.8,"endofround")
                        set_task(1.0,"timedis3",454500,"",0,"b")
                }
                return PLUGIN_HANDLED
        }
        else
        {
                if(waited==0)
                {
                        set_task(1.0,"show_timer")
                }
                
                if(isbetween || isbuytime || (waited + addthiswait) > 190 || activeplayers<1 )
                {
                        remove_task(333333)
                        remove_task(454500)
                        if(isbetween)
                        {
                                set_task(3.9,"endofround")
                        }
                        else
                        {
                                endofround()
                        }
                }
                else
                {
                        waited+=5
                        if(waited>=15&&waited<=150&&get_timeleft()<7)
                        {
                                istimeset2=1
                                set_cvar_float("mp_timelimit", get_cvar_float("mp_timelimit") + 2.0 )
                                client_print(0,print_chat,"%L", LANG_PLAYER, "EXTEND_ROUND_TIME_TO_FIN")
                        }
                        
                        set_task(5.0,"RoundMode",333333)
                }
        }
        
        return PLUGIN_HANDLED
}


public vote_count(id,key)
{
        if ( get_cvar_float("amx_vote_answers") )
        {
                new name[32]
                get_user_name(id,name,31)
                if ( key == maps_to_select )
                {
                        client_print(0,print_chat,"%L", LANG_PLAYER, "PLAYER_CHOSE_EXTEND", name )
                }
                else if ( key < maps_to_select )
                {
                        client_print(0,print_chat,"%L", LANG_PLAYER, "PLAYER_CHOSE_MAP", name, nmaps[nnextmaps[key]] )
                }
        }
        
        nvotes[key]=nvotes[key]+1
        return PLUGIN_HANDLED
}


bool:isinmenu(id)
{
        new a
        
        for(a=0; a<nmapstoch; ++a)
        {
                if (id==nnextmaps[a])
                {
                        return true
                }
        }
        
        return false
}


public levelchange()
{
        if(istimeset2==1)
        {
                set_cvar_float("mp_timelimit",get_cvar_float("mp_timelimit")-2)
                istimeset2=0
        }
        else
        {
                if(get_cvar_float("mp_timelimit")>=4.0)
                {
                        if(!istimeset)
                        {
                                oldtimelimit=get_cvar_float("mp_timelimit")
                                set_cvar_float("mp_timelimit",get_cvar_float("mp_timelimit")-3)
                                istimeset=1
                        }
                }
                else if(get_cvar_num("mp_winlimit"))
                {
                        new largerscore
                        largerscore=(teamscore[0]>teamscore[1])?teamscore[0]:teamscore[1]
                        iswinlimitset=1
                        oldwinlimit=get_cvar_num("mp_winlimit")
                        set_cvar_num("mp_winlimit",largerscore)
                }
        }
        
        set_task(2.1,"DelayedChange",444444)
}


public changeMap()
{
        set_cvar_float( "mp_chattime" , 3.0 )
        remove_task(444444)
        set_task( 1.85 , "DelayedChange")
}


public DelayedChange()
{
        new smap[32]
        
        if(dofreeze)
        {
                set_cvar_num("mp_freezetime",storedfreezetime)
        }
        
        get_cvar_string("amx_nextmap",smap,31)
        server_cmd( "changelevel %s", smap )
}


public endofround()
{
        remove_task(123452)
        remove_task(987111)
        remove_task(333333)
        remove_task(454510)
        remove_task(454500)
        remove_task(123499)
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        set_task(6.0,"levelchange")

        if(quiet!=2)
        {
                countnum=0
                set_task(1.0,"countdown",123400,"",0,"a",6)
                if(quiet!=1)
                {
                        client_cmd(0,"speak ^"loading environment on to your computer^"")
                }
        }
        else
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "MAP_TO_CHANGE")
                client_print(0,print_chat,"%L", LANG_PLAYER, "MAP_NEXT",smap)
                if( (containi(mapsurl,"www")!=-1||containi(mapsurl,"http")!=-1) &&iscustommap(smap))
                {
                      client_print(0,print_chat,"%L", LANG_PLAYER, "CUSTOM_MAP_LIKE_DL_LOC",smap,mapsurl)
                }
        }
        
        if(dofreeze)
        {
                isspeedset=1
                thespeed=get_cvar_float("sv_maxspeed")
                set_cvar_float("sv_maxspeed", 0.0)
                new players[32], inum, i
                get_players(players,inum,"c")

                for(i = 0 ;i < inum; ++i)
                {
                        client_cmd(players[i],"drop")
                        client_cmd(players[i],"+showscores")
                }
        }
        
        if(dofreeze)
        {
                set_task(1.1,"stopperson",123450,"",0,"a",2)
        }

        return PLUGIN_HANDLED
}


public countdown()
{
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        countnum++
        set_hudmessage(150, 120,0, -1.0, 0.3, 0, 0.5, 1.1, 0.1, 0.1, 8)
        show_hudmessage(0,"Map changing to %s in %d seconds.",smap,7-countnum)
        
        return PLUGIN_HANDLED
}


public stopperson()
{
        new players[32], inum, i
        get_players(players,inum,"c")

        if(isspeedset>=0&&isspeedset<2)
        {
                thespeed=get_cvar_float("sv_maxspeed")
                isspeedset++
                set_cvar_float("sv_maxspeed", 0.0)
        }
        
        for(i = 0 ;i < inum; ++i)
        {
                client_cmd(players[i],"drop")
        }
        
        return PLUGIN_HANDLED
}

public display_message()
{
        new timeleft = get_timeleft()
        new parttime=timeleft%(frequency*60*2)
        new addition=frequency*60

        if(mselected||inprogress||cycle)
        {
                return PLUGIN_CONTINUE
        }
        
        if(parttime>(40+addition)&&parttime<(56+addition)&&timeleft>132)
        {
                set_task(3.0,"messagenominated",986100,"",0,"a",4)
        }
        else
        {
                if(parttime>30&&parttime<46&&timeleft>132)
                {
                        set_task(10.0,"messagemaps",986200,"",0,"a",1)
                }
                else if(timeleft>=117&&timeleft<132)
                {
                        messagefifteen()
                }
        }
        
        return PLUGIN_CONTINUE
}
// THIS IS UNTESTED, BUT SHOULD WORK
/* 1.6 hudtext function
Arguments:
textblock: a string containing the text to print, not more than 512 chars (a small calc shows that the max number of letters to be displayed is around 270 btw)
colr, colg, colb: color to print text in (RGB format)
posx, posy: position on screen * 1000 (if you want text to be displayed centered, enter -1000 for both, text on top will be posx=-1000 & posy=20
screen: the screen to write to, hl supports max 4 screens at a time, do not use screen+0 to screen+3 for other hudstrings while displaying this one
time: how long the text shoud be displayed (in seconds)
*/


public hudtext16(textblock[],colr,colg,colb,posx,posy,screen,time,id)
{
        new y

        if(contain(textblock,"^n") == -1)
        {
                set_hudmessage(colr, colg, colb, float(posx)/1000.0, float(posy)/1000.0, 0, 6.0, float(time), 0.2, 0.2, screen)
                show_hudmessage(id,textblock)
        }
        else
        {
                new out[128]
                new rowcounter=0
                new tmp[512]
                new textremain=true;y=screen
                new i = contain(textblock,"^n")
                copy(out,i,textblock)
                
                do
                {
                        setc(tmp,511,0)
                        copy(tmp,511,textblock[i+1])
                        setc(textblock,511,0)
                        copy(textblock,511,tmp)
                        i = contain(textblock,"^n")
                        
                        if((strlen(out)+i < 64) && (i != -1))
                        {
                                add(out,127,"^n")
                                add(out,strlen(out)+i,textblock)
                                rowcounter++
                        }
                        else
                        {
                                set_hudmessage(colr, colg, colb, float(posx)/1000.0, float(posy)/1000.0, 0, 6.0, float(time), 0.2, 0.2, screen)
                                
                                if((i == -1) && (strlen(out)+strlen(textblock) < 64))
                                {
                                        add(out,127,"^n")
                                }
                                else
                                {
                                        if(screen-y < 4)
                                        {
                                                show_hudmessage(id,out)
                                        }
                                        
                                        screen++
                                        rowcounter++
                                        setc(out,127,0)
                                        
                                        for(new j=0;j<rowcounter;j++)
                                        {
                                                add(out,127,"^n")
                                        }
                                        
                                        if(i == -1)
                                        {
                                                set_hudmessage(colr, colg, colb, float(posx)/1000.0, float(posy)/1000.0, 0, 6.0, float(time), 0.2, 0.2, screen)
                                        }
                                        else
                                        {
                                                add(out,strlen(out)+i,textblock)
                                        }
                                }
                                
                                if(i == -1)
                                {
                                        add(out,strlen(out)+strlen(textblock),textblock)
                                        
                                        if(screen-y < 4)
                                        {
                                                show_hudmessage(id,out)
                                        }
                                        
                                        textremain = false
                                }
                        }
                }
                while(textremain)
        }
        return screen-y
}


public messagenominated()
{
        new string[256] = ""
        new string2[256] = ""
        new string3[512] = ""
        
        if(quiet == 2)
        {
                return PLUGIN_CONTINUE
        }

        if(nmaps_num < 1)
        {
                format(string3,511,"%L", LANG_PLAYER, "NO_MAP_NOMINATED_HUD")
        }
        else
        {
                new n=0
                new foundone=0
                format(string,255,"%L", LANG_PLAYER, "NOM_FOR_NEXT_VOTE_HUD")
                
                while((n < 3) && (n < nmaps_num))
                {
                        format(string,255,"%s  %s",string,nmaps[n++])
                }
                
                while((n < 6) && (n < nmaps_num))
                {
                        foundone=1
                        format(string2,255,"%s   %s",string2,nmaps[n++])
                }

                if(foundone)
                {
                        format(string3,511,"%s^n%s",string,string2)
                }
                else
                {
                        format(string3,511,"%s",string)
                }
        }

        hudtext16(string3,random_num(0,222),random_num(0,111),random_num(111,222),-1000,50,random_num(6,8),10,0)
        return PLUGIN_CONTINUE
}


public listnominations(id)
{
        new a = 0
        new string1[128] = ""
        new string3[512] = ""
        
        if(a < nmaps_num)
        {
                format(string3,511,"%L", LANG_PLAYER, "NOMINATED_VOTE_HUD")
        }

        while(a < nmaps_num)
        {
                new name1[25]
                get_user_name(whonmaps_num[a], name1, 25)
                format(string1,127,"^n%s by: %s",nmaps[a],name1)
                add(string3,511,string1,127)
                a++
        }

        hudtext16(string3,random_num(0,222),random_num(0,111),random_num(111,222),300,10,random_num(6,8),15,id)
}


public messagemaps()
{
        new string[256] = ""
        new string2[256] = ""
        new string3[512] = ""

        if(quiet==2)
        {
                return PLUGIN_CONTINUE
        }

        new n
        new total=0
        
        if((totalmaps-6) > 0)
        {
                n=random_num(0,totalmaps-6)
        }
        else
        {
                n=0
        }

        while((total<3) && (total<totalmaps) && (is_map_valid(listofmaps[n])) && (n<totalmaps))
        {
                if((!islastmaps(listofmaps[n])) && (!isbanned(listofmaps[n])) && (!isnominated(listofmaps[n])))
                {
                        format(string,63,"%s   %s",string,listofmaps[n])
                        total++
                }
                
                n++
        }
        
        while((total<6) && (n<totalmaps) && (is_map_valid(listofmaps[n])) && (!isnominated(listofmaps[n])))
        {
                if(!islastmaps(listofmaps[n])&&!isbanned(listofmaps[n]))
                {
                        format(string2,63,"%s     %s",string2,listofmaps[n])
                        total++
                }
                
                n++
        }

        if(total>0)
        {
                format(string3,511,"%L", LANG_PLAYER, "AVAIL_TO_NOMINATE_HUD")
                add(string3,511,string,255)
                add(string3,511,"^n")
        }

        if(total>3)
        {
                add(string3,511,string2,255)
        }
        
        hudtext16(string3,random_num(0,222),random_num(0,111),random_num(111,222),-1000,50,random_num(6,8),10,0)
        return PLUGIN_CONTINUE
}


public messagefifteen()
{
        if(quiet==2)
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "MAP_VOTE_BEGIN_15SEC")
                return PLUGIN_HANDLED
        }

        set_hudmessage(0, 222,50, -1.0, 0.23, 1, 6.5, 6.5, 1.0, 3.0, 8)
        show_hudmessage(0,"%L", LANG_PLAYER, "MAP_VOTE_BEGIN_15SEC_HUD")

        if(quiet==0)
        {
                client_cmd(0,"spk ^"get red(e80) ninety(s45) to check(e20) use bay(s18) mass(e42) cap(s50)^"")
        }

        set_task(8.7,"getready",459100)
        return PLUGIN_HANDLED
}


public getready()
{
        if(!cycle)
        {
                set_task(0.93,"timetovote",459200,"",0,"a",5)
        }
}


public timetovote()
{
        counttovote++
        new speak[5][] = {"one","two","three","four","five"}

        if(get_timeleft()>132 || counttovote>5 || cycle || isbuytime)
        {
                counttovote=0
                remove_task(459200)
                remove_task(459100)
                return PLUGIN_HANDLED
        }
        else
        {
                if(counttovote>0 && counttovote<=5)
                {
                        set_hudmessage(0, 222,50, -1.0, 0.13, 0, 1.0, 0.94, 0.0, 0.0, 8)
                        show_hudmessage(0,"%L", LANG_PLAYER, "MAP_VOTE_BEGIN_SEC_HUD",6-counttovote)
                        if(quiet!=1)
                        {
                                client_cmd(0,"spk ^"fvox/%s^"",speak[5-counttovote])
                        }
                }
        }

        return PLUGIN_HANDLED
}


available_maps()
{
        new num=0
        new isinlist
        new current_map[32]
        new a
        new i
        get_mapname(current_map,31)

        for(a=0;a<num_nmapsfill;a++)
        {
                if(is_map_valid(nmapsfill[a]))
                {
                        isinlist=0

                        for(i = 0; i < nmaps_num; i++)
                        {
                                if(equali(nmapsfill[a],nmaps[i]))
                                {
                                        isinlist=1
                                }
                        }
                        
                        if(!isinlist)
                        {
                                num++
                        }
                }
        }

        return num
}


public askfornextmap()
{
        display_message()
        new timeleft=get_timeleft()

        if(isspeedset&&timeleft>30)
        {
                isspeedset=0
                set_cvar_float("sv_maxspeed", thespeed)
        }
        
        if(waited>0)
        {
                return PLUGIN_HANDLED
        }
        
        if(timeleft>300)
        {
                isend=0
                remove_task(123452)
        }
        
        new mp_winlimit = get_cvar_num("mp_winlimit")
        
        if (mp_winlimit)
        {
                new s=mp_winlimit-2
                if ((s>teamscore[0]&&s>teamscore[1])&&(timeleft>114||timeleft<1))
                {
                        remove_task(454500)
                        mselected = false
                        return PLUGIN_HANDLED
                }
        }
        else
        {
                if(timeleft>114||timeleft<1)
                {
                        if(timeleft>135)
                        {
                                remove_task(454510)
                                remove_task(454500)
                                remove_task(123499)
                        }
                        else
                        {
                                remove_task(454500)
                        }

                        mselected = false
                        return PLUGIN_HANDLED
                }
        }
        
        if (inprogress||mselected||cycle)
        {
                return PLUGIN_HANDLED
        }

        mselected=false
        inprogress=1
        
        if(mp_winlimit&&!(timeleft>=115&&timeleft<134))
        {
                if(quiet!=2)
                {
                        set_hudmessage(0, 222,50, -1.0, 0.13, 1, 6.0, 6.0, 1.0, 1.0, 8)
                        show_hudmessage(0,"%L", LANG_PLAYER, "ATTN_VOTE_BEGIN_HUD")
                
                        if(quiet!=1)
                        {
                                client_cmd(0,"spk ^"get red(e80) ninety(s45) to check(e20) use bay(s18) mass(e42) cap(s50)^"")
                        }
                        
                        set_task(4.2,"getready",459100)
                        set_task(10.0,"startthevote")
                }
                else
                {
                        set_task(1.0,"startthevote")
                }
        }
        else
        {
                set_task(0.5,"startthevote")
        }
        
        return PLUGIN_HANDLED
}


public startthevote()
{
        new mp_winlimit=get_cvar_num("mp_winlimit")
        new j

        if(cycle)
        {
                inprogress=0
                mselected=false
                remove_task(459200)
                remove_task(459100)
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                client_print(0,print_chat,"%L", LANG_PLAYER, "MAP_NEXT",smap)
                return PLUGIN_HANDLED
        }
        
        for(j=0;j<maps_to_select+2;j++)
        {
                nvotes[j]=0
        }

        mselected=true
        inprogress=1
        counttovote=0

        if((isbuytime||isbetween)&&get_timeleft()&&get_timeleft()>54)
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_DELAY_BUY")

                if(isbetween)
                {
                        set_task(15.0,"getready",459100)
                        set_task(21.0,"startthevote")
                }
                else
                {
                        set_task(8.0,"getready",459100)
                        set_task(14.0,"startthevote")
                }

                return PLUGIN_HANDLED
        }
        
        remove_task(459200)
        remove_task(459100)

        if(quiet!=2)
        {
                client_print(0,print_chat,"%L", LANG_PLAYER, "NOM_VOTE_OUT_OF",nmaps_num,maps_to_select)
        }

        log_amx("%L", LANG_SERVER, "LOG_AMX_NOM_VOTE_OUT_OF",nmaps_num,maps_to_select)
        new available
        before_num_nmapsfill=num_nmapsfill
        available=available_maps()

        if((nmaps_num+available)<(maps_to_select+1))
        {
                new current_map[32]
                get_mapname(current_map,31)
                new overflowprotect=0
                new used[MAX_MAPS_AMOUNT]
                new k=num_nmapsfill
                new totalfilled=0
                new alreadyused
                new tryfill
                new q
                new listpossible=totalmaps

                while(((available_maps()+nmaps_num)<(maps_to_select+7))&&listpossible>0)
                {
                        alreadyused=0
                        q=0
                        tryfill=random_num(0,totalmaps-1)
                        overflowprotect=0

                        while(used[tryfill]&&overflowprotect++<=totalmaps*15)
                        {
                                tryfill=random_num(0,totalmaps-1)
                        }

                        if(overflowprotect>=totalmaps*15)
                        {
                                alreadyused=1
                                log_amx("%L", LANG_SERVER, "LOG_AMX_OVERFLOW_NOT_NUFF_MAPS")
                                listpossible-=1
                        }
                        else
                        {
                                while(q<num_nmapsfill&&!alreadyused)
                                {
                                        if(equali(listofmaps[tryfill],nmapsfill[q]))
                                        {
                                                alreadyused=used[tryfill]=1
                                                listpossible--
                                        }
                                        q++
                                }

                                q=0

                                while(q<nmaps_num&&!alreadyused)
                                {
                                        if(equali(listofmaps[tryfill],nmaps[q]))
                                        {
                                                alreadyused=used[tryfill]=1
                                                listpossible--
                                        }
                                        q++
                                }
                        }
                        
                        if(!alreadyused)
                        {
                                if(equali(listofmaps[tryfill],current_map) || equali(listofmaps[tryfill],last_map)||islastmaps(listofmaps[tryfill])||isbanned(listofmaps[tryfill]))
                                {
                                        listpossible--
                                        used[tryfill]=1
                                }
                                else
                                {
                                        nmapsfill[k]=listofmaps[tryfill]
                                        num_nmapsfill++
                                        listpossible--
                                        used[tryfill]=1
                                        k++
                                        totalfilled++
                                }
                        }
                }
                
                log_amx("%L", LANG_SERVER, "LOG_AMX_FILLED_MAPS",totalfilled)
        }

        nbeforefill=nmaps_num

        if(nmaps_num<maps_to_select)
        {
                new need=maps_to_select-nmaps_num
                console_print(0,"%L", LANG_PLAYER, "RANDOM_MAP_FILL", need)
                log_amx("%L", LANG_SERVER, "LOG_AMX_RANDOM_MAP_FILL", need,num_nmapsfill)
                new fillpossible=num_nmapsfill
                new k=nmaps_num
                new overflowprotect=0
                new used[MAX_MAPS_AMOUNT]
                new totalfilled=0
                new alreadyused
                new tryfill

                if(num_nmapsfill<1)
                {
                        if(quiet!=2)
                        {
                                client_print(0,print_chat,"%L", LANG_PLAYER, "UNABLE_FILL_TXT")
                        }
                        
                        log_amx("%L", LANG_SERVER, "LOG_AMX_UNABLE_FILE_TXT")
                }
                else
                {
                        while(fillpossible>0&&k<maps_to_select)
                        {
                                alreadyused=0
                                new q=0
                                tryfill=random_num(0,num_nmapsfill-1)
                                overflowprotect=0

                                while(used[tryfill]&&overflowprotect++<=num_nmapsfill*10)
                                {
                                        tryfill=random_num(0,num_nmapsfill-1)
                                }

                                if(overflowprotect>=num_nmapsfill*15)
                                {
                                        alreadyused=1
                                        log_amx("%L", LANG_SERVER, "LOG_AMX_OVERFLOW_NOT_NUFF_MAPS")
                                        fillpossible-=2
                                }
                                else
                                {
                                        while(q<nmaps_num&&!alreadyused)
                                        {
                                                if(equali(nmapsfill[tryfill],nmaps[q]))
                                                {
                                                        alreadyused=used[tryfill]=1
                                                        fillpossible--
                                                }
                                                q++
                                        }
                                }

                                if(!alreadyused)
                                {
                                        nmaps[k]=nmapsfill[tryfill]
                                        nmaps_num++
                                        fillpossible--
                                        used[tryfill]=1
                                        k++
                                        totalfilled++
                                }

                        }
                        
                        if(totalfilled==0)
                        {
                                console_print(0,"%L", LANG_PLAYER, "UNABLE_FILL_SRV")
                        }
                        else
                        {
                                if(quiet!=2)
                                {
                                        console_print(0,"%L", LANG_PLAYER, "FILLED_RANDOM",totalfilled)
                                }

                                log_amx("%L", LANG_SERVER, "LOG_AMX_FILLED_RANDOM",totalfilled)
                        }
                }
        }
                
        new menu[512]
        new a
        new mkeys = (1<<maps_to_select+1)
        new Float:steptime = get_cvar_float("amx_extendmap_step")
        new extendint
        extendint=floatround(steptime)
        new pos
        
        if(cstrike_running())
        {
                pos = format(menu,511,"%L", LANG_PLAYER, "CHOOSE_NEXT_MAP_CS_HUD")
        }
        else
        {
                pos = format(menu,511,"%L", LANG_PLAYER, "CHOOSE_NEXT_MAP_HUD")
        }
        
        //new pos = copy(menu,511,cstrike_running() ? "\rChoose the next map:\w^n^n" : "Choose the next map:^n^n")
        new dmax = (nmaps_num > maps_to_select) ? maps_to_select : nmaps_num

        for(nmapstoch = 0;nmapstoch<dmax;++nmapstoch)
        {
                a=random_num(0,nmaps_num-1)

                while( isinmenu(a) )
                {
                        if (++a >= nmaps_num)
                        {
                                a = 0
                        }
                }
                                
                nnextmaps[nmapstoch] = a

                if(iscustommap(nmaps[a])&&usestandard)
                {
                        if(cstrike_running())
                        {
                                pos += format(menu[pos],511,"%L", LANG_PLAYER, "MAP_CHOOSE_CUSTOM_CS_HUD",nmapstoch+1,nmaps[a])
                        }
                        else
                        {
                                pos += format(menu[pos],511,"%L", LANG_PLAYER, "MAP_CHOOSE_CUSTOM_HUD",nmapstoch+1,nmaps[a])
                        }
                }
                else
                {
                        pos += format(menu[pos],511,"%d. %s^n",nmapstoch+1,nmaps[a])
                }

                mkeys |= (1<<nmapstoch)
                nvotes[nmapstoch] = 0
        }
                
        menu[pos++]='^n'
        nvotes[maps_to_select] = 0
        nvotes[maps_to_select+1] = 0
        new mapname[32]
        get_mapname(mapname,31)

        if (!mp_winlimit && get_cvar_float("mp_timelimit") < get_cvar_float("amx_extendmap_max"))
        {
                pos += format(menu[pos],511,"%L", LANG_PLAYER, "CHOOSE_EXTEND_MAP_HUD",maps_to_select+1,mapname,extendint)
                mkeys |= (1<<maps_to_select)
        }

        format(menu[pos],511,"%L", LANG_PLAYER, "CHOOSE_NONE_HUD",maps_to_select+2)
        show_menu(0,mkeys,menu,19)
        set_task(20.0,"check_votes")
        client_print(0,print_chat,"%L", LANG_PLAYER, "TIME_TO_CHOOSE")

        if(quiet==0)
        {
                client_cmd(0,"spk Gman/Gman_Choose%d",random_num(1,2))
        }
                
        log_amx("%L", LANG_SERVER, "LOG_AMX_VOTE_START")
        return PLUGIN_HANDLED
}


public handle_andchange(id,map2[])
{
        new tester[128] = ""
        new i = 0

        if(is_map_valid(map2)==1)
        {
                handle_nominate(id,map2)
        }
        else
        {
                while( i < maptypecount )
                {
                        format(tester,127,"%s_%s",maptypes[i],map2)

                        if(is_map_valid(tester)==1)
                        {
                                i = 6
                        }
                        i++
                }

                if(i > maptypecount+1)
                {
                        handle_nominate(id,tester)
                }
                else
                {
                        handle_nominate(id,map2)
                }
        }
}


public HandleSay(id)
{
        new chat[256]
        read_args(chat, 255)
        new saymap[256]
        new i = 0
        saymap=chat
        remove_quotes(saymap)
        new saymap2[256]
        read_args(saymap2,255)
        remove_quotes(saymap2)
        new chat2[256]

        if(containi(chat, "<")!=-1||containi(chat, "?")!=-1||containi(chat, ">")!=-1||containi(chat, "*")!=-1||containi(chat, "&")!=-1||containi(chat, ".")!=-1)
        {
                return PLUGIN_CONTINUE
        }

        if(containi(chat, "nominations") != -1)
        {
                if(mselected)
                {
                        client_print(id,print_chat, "%L", id, "VOTE_IN_PROGRESS")
                }
                else
                {
                        if(nmaps_num==0)
                        {
                                client_print(id,print_chat, "%L", id, "NO_MAP_NOMINATE")
                        }
                        else
                        {
                                listnominations(id)
                        }
                }
        }
        else
        {
                if(containi(chat, "nominate ") == 1)
                {
                        new mycommand[32]
                        read_args(mycommand,32)
                        remove_quotes(mycommand)
                        handle_andchange(id,mycommand[9])
                }
                else
                {
                        if(containi(chat, "vote ") == 1)
                        {
                                new mycommand[32]
                                read_args(mycommand,32)
                                remove_quotes(mycommand)
                                handle_andchange(id,mycommand[5])
                        }
                        else
                        {
                                if(is_map_valid(saymap)==1)
                                {
                                        handle_nominate(id,saymap)
                                }
                                else
                                {
                                
                                        while( i < maptypecount )
                                        {
                                                format(chat2,255,"%s_%s",maptypes[i],saymap2)
                                                // log_amx("DEBUG: MapManager - Chat2: %s, maptype[%d]: %s, text: %s",chat2,i,maptypes[i],saymap2)

                                                if(is_map_valid(chat2)==1)
                                                {
                                                        i = 6
                                                }
                                                i++
                                        }

                                        if(i > maptypecount+1)
                                        {
                                                handle_nominate(id,chat2)
                                        }
                                        else
                                        {
                                                return PLUGIN_CONTINUE
                                        }
                                }
                        }
                }
        }

        return PLUGIN_CONTINUE
}


public calculate_custom()
{
        amt_custom=0
        new i

        for(i = 0; i < nmaps_num; i++)
        {
                if (iscustommap(nmaps[i]))
                {
                        amt_custom++
                }
        }
}


public handle_nominate(id,map[])
{
        strtolower(map)
        new current_map[32]
        new iscust=0
        new iscust_t=0
        new full;full=(amt_custom>=maxcustnom)
        new n=0
        new i
        new done=0
        new isreplacement=0
        new tempnmaps=nmaps_num
        get_mapname(current_map,31)

        if(inprogress&&mselected)
        {
                client_print(id,print_chat,"%L", id, "VOTE_CURRENT_PROGRESS")
                return PLUGIN_HANDLED
        }
        
        if(mselected)
        {
                new smap[32]
                get_cvar_string("amx_nextmap",smap,31)
                client_print(id,print_chat, "%L", id, "VOTE_OVER_NEXT_MAP",smap)
                return PLUGIN_HANDLED
        }

        if(!is_map_valid(map)||is_map_valid(map[1]))
        {
                client_print(id,print_chat,"%L", id, "MAP_NOT_FOUND_DMM",map)
                return PLUGIN_HANDLED
        }
        
        if(isbanned(map))
        {
                client_print(id,print_chat,"%L", id, "VOTE_BAN_MAP")
                return PLUGIN_HANDLED
        }
        
        if(islastmaps(map)&&!equali(map,current_map))
        {
                client_print(id,print_chat,"%L", id, "VOTE_BAN_LASTMAPS",ban_last_maps)
                return PLUGIN_HANDLED
        }

        if (equali(map,current_map))
        {
                client_print(id,print_chat,"%L", id, "VOTE_CURRENT_MAP",map)
                return PLUGIN_HANDLED
        }

        if(get_cvar_num("dmap_strict"))
        {
                new isinthelist=0

                for(new a=0; a<totalmaps;a++)
                {
                        if(equali(map,listofmaps[a]))
                        {
                                isinthelist=1
                        }
                }
                
                if(!isinthelist)
                {
                        client_print(id,print_chat,"%L", id, "NOMINATE_CERTAIN_MAP")
                        return PLUGIN_HANDLED
                }
        }

        iscust=iscustommap(map)
        
        if(nmaps_num>=maps_to_select||Nominated[id]>=maxnom)
        {
                if(Nominated[id]>maxnom)
                {
                        client_print(id,print_chat,"%L", id, "MAX_NOMINATED_MAPS")
                        return PLUGIN_HANDLED
                }

                for(i = 0; i < nmaps_num; i++)
                {
                        if (equali(map,nmaps[i]))
                        {
                                new name[32]
                                get_user_name(whonmaps_num[i], name, 32)

                                if(quiet==2)
                                {
                                        client_print(id,print_chat,"%L", id, "ALREADY_NOMINATED_BY",map,name)
                                }
                                else
                                {
                                        client_print(0,print_chat,"%L", LANG_PLAYER, "ALREADY_NOMINATED_BY",map,name)
                                }

                                return PLUGIN_HANDLED
                        }
                }
                        
                while(n<nmaps_num&&!done&&Nominated[id]>1)
                {
                        if(whonmaps_num[n]==id)
                        {
                                iscust_t=iscustommap(nmaps[n])

                                if(!(full&&iscust&&!iscust_t))
                                {
                                        Nominated[id]=Nominated[id]-1
                                        nmaps_num=n
                                        done=1
                                        isreplacement=1
                                }
                        }
                        n++
                }

                if(!done)
                {
                        n=0

                        while(n<nmaps_num&&!done&&Nominated[id]<2)
                        {
                                if(Nominated[whonmaps_num[n]]>2)
                                {
                                        iscust_t=iscustommap(nmaps[n])

                                        if(!(full&&iscust&&!iscust_t))
                                        {
                                                done=1
                                                Nominated[whonmaps_num[n]]=Nominated[whonmaps_num[n]]-1
                                                nmaps_num=n
                                                isreplacement=2
                                        }
                                }
                                n++
                        }
                }

                if(!done)
                {
                        n=0

                        while(n<nmaps_num&&!done&&Nominated[id]<1)
                        {

                                if(Nominated[whonmaps_num[n]]>1)
                                {
                                        iscust_t=iscustommap(nmaps[n])

                                        if(!(full&&iscust&&!iscust_t))
                                        {
                                                done=1
                                                Nominated[whonmaps_num[n]]=Nominated[whonmaps_num[n]]-1
                                                nmaps_num=n
                                                isreplacement=2
                                        }
                                }
                                n++
                        }
                }

                if(!done)
                {
                        n=0

                        while(n<nmaps_num&&!done&&Nominated[id]>0)
                        {
                                if(whonmaps_num[n]==id)
                                {
                                        iscust_t=iscustommap(nmaps[n])

                                        if(!(full&&iscust&&!iscust_t))
                                        {
                                                Nominated[id]=Nominated[id]-1
                                                nmaps_num=n
                                                done=1
                                                isreplacement=1
                                        }
                                }
                                n++
                        }
                }

                if(!done)
                {
                        client_print(id,print_chat,"%L", id, "MAX_NOMINATIONS",nmaps_num)
                        return PLUGIN_HANDLED
                }
        }
        
        for(i = 0; i < nmaps_num; i++)
        {
                if (equali(map,nmaps[i]))
                {
                        new name[32]
                        get_user_name(whonmaps_num[i], name, 32)
                        client_print(id,print_chat,"%L", id, "ALREADY_NOMINATED_BY",map,name)
                        nmaps_num=tempnmaps
                        return PLUGIN_HANDLED
                }
        }
        
        if(!isreplacement&&iscust&&full)
        {
                client_print(id,print_chat,"%L", id, "MAX_CUSTOM_NOMINATIONS",maxcustnom)
                return PLUGIN_HANDLED
        }

        new name[32]
        get_user_name(id, name, 21)

        if(isreplacement==1)
        {
                if(quiet==2)
                {
                        client_print(id, print_chat, "%L", id, "YOU_REPLACE_NOMINATION",nmaps[nmaps_num])
                }
                else
                {
                        client_print(0, print_chat, "%L", LANG_PLAYER, "PUB_REPLACE_NOMINATION",name,nmaps[nmaps_num])
                }
        }
        else if(isreplacement==2)
        {
                if(quiet==2)
                {
                        client_print(0,print_chat, "%L", LANG_PLAYER, "PREV_REPLACE_NOMINATION",nmaps[nmaps_num])
                }
                else
                {
                        new name21[32]
                        get_user_name(whonmaps_num[nmaps_num], name21, 31)
                        client_print(0,print_chat, "%L", LANG_PLAYER, "PUB_PREV_REPLACE_NOMINATION",name21,nmaps[nmaps_num])
                }
        }

        Nominated[id]++
        console_print(id,"%L", id, "CONSOLE_ADD_NOMINATION",map,nmaps_num+1)
        set_task(0.18,"calculate_custom")
        copy(nmaps[nmaps_num],31,map)
        whonmaps_num[nmaps_num]=id

        if(isreplacement)
        {
                nmaps_num=tempnmaps
        }
        else
        {
                nmaps_num=tempnmaps+1
        }
        
        client_print(0,print_chat,"%L", LANG_PLAYER, "HAS_NOMINATED_LIST",name,map)
        return PLUGIN_HANDLED
}


public team_score()
{
        new team[2]
        read_data(1,team,1)
        teamscore[ (team[0]=='C') ? 0 : 1 ] = read_data(2)
        return PLUGIN_CONTINUE
}


public plugin_end()
{
        new current_map[32]
        get_mapname(current_map,31)
        set_localinfo("amx_lastmap",current_map)

        if(istimeset)
        {
                set_cvar_float("mp_timelimit",oldtimelimit)
        }
        else
        {
                if(istimeset2)
                {
                        set_cvar_float("mp_timelimit",get_cvar_float("mp_timelimit")-2)
                }
        }

        if(isspeedset)
        {
                set_cvar_float("sv_maxspeed",thespeed)
        }
                
        if(iswinlimitset)
        {
                set_cvar_num("mp_winlimit",oldwinlimit)
        }
        
        return PLUGIN_CONTINUE
}


public get_listing()
{
        new i=0
        new iavailable=0
        new line=0
        new p
        new stextsize = 0
        new isinthislist=0
        new found_a_match=0
        new done=0
        new linestr[256]
        new maptext[32]
        new current_map[32]
        new amapfile[64]
        get_configsdir(amapfile, 63)
        format(amapfile, 63, "%s/map_manage/allmaps.txt", amapfile)
        get_mapname(current_map,31)
        pathtomaps="mapcycle.txt"
        new smap[32]
        get_cvar_string("amx_nextmap",smap,31)
        
        if (file_exists(pathtomaps))
        {
                while(read_file(pathtomaps,line,linestr,255,stextsize)&&!done)
                {
                        format(maptext,31,"%s",linestr)

                        if(is_map_valid(maptext)&&!is_map_valid(maptext[1])&&equali(maptext,current_map))
                        {
                                done=found_a_match=1
                                line++

                                if(read_file(pathtomaps,line,linestr,255,stextsize))
                                {
                                        format(maptext,31,"%s",linestr)

                                        if(is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                                        {
                                                if(equali(smap,""))
                                                {
                                                        register_cvar("amx_nextmap","",FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_SPONLY)
                                                }
                                                
                                                set_cvar_string("amx_nextmap",maptext)
                                        }
                                        else
                                        {
                                                found_a_match=0
                                        }
                                }
                                else
                                {
                                        found_a_match=0
                                }
                        }
                        else
                        {
                                line++
                        }
                }

                if(!found_a_match)
                {
                        line=0

                        while(read_file(pathtomaps,line,linestr,255,stextsize)&&!found_a_match&&line<1024)
                        {
                                format(maptext,31,"%s",linestr)

                                if(is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                                {
                                        if(equali(smap,""))
                                        {
                                                register_cvar("amx_nextmap","",FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_SPONLY)
                                        }
                                        
                                        set_cvar_string("amx_nextmap",maptext)
                                        found_a_match=1
                                }
                                else
                                {
                                        line++
                                }
                        }
                }
        }

        line=0
        pathtomaps = amapfile

        if (!file_exists(pathtomaps))
        {
                pathtomaps="mapcycle.txt"
        }

        if(file_exists(pathtomaps))
        {
                while(read_file(pathtomaps,line,linestr,255,stextsize)&&i<MAX_MAPS_AMOUNT)
                {
                        format(maptext,31,"%s",linestr)

                        if(is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                        {
                                isinthislist=0

                                for(p=0;p<i;p++)
                                {
                                        if(equali(maptext,listofmaps[p]))
                                        {
                                                isinthislist=1
                                        }
                                }

                                if(!isinthislist)
                                {
                                        listofmaps[i++]=maptext
                                }
                        }
                        line++
                }
        }

        line=0

        for(p=0;p<i;p++)
        {
                if(!isbanned(listofmaps[p])&&!islastmaps(listofmaps[p]))
                {
                        iavailable++
                }
        }
                
        if(iavailable<maps_to_select&&!equali(pathtomaps,"mapcycle.txt"))
        {
                pathtomaps="mapcycle.txt"

                if (file_exists(pathtomaps))
                {
                        while(read_file(pathtomaps,line,linestr,255,stextsize)&&i<MAX_MAPS_AMOUNT)
                        {
                                format(maptext,31,"%s",linestr)

                                if(is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                                {
                                        isinthislist=0

                                        for(p=0;p<i;p++)
                                        {
                                                if(equali(maptext,listofmaps[p]))
                                                {
                                                        isinthislist=1
                                                }
                                        }

                                        if(!isinthislist)
                                        {
                                                listofmaps[i++]=maptext
                                        }
                                }
                                line++
                        }
                }
        }

        totalmaps=i
        iavailable=0

        for(p=0;p<i;p++)
        {
                if(!isbanned(listofmaps[p])&&!islastmaps(listofmaps[p]))
                {
                        iavailable++
                }
        }

        log_amx("%L", LANG_SERVER, "LOG_AMX_FOUND_MAP_TXT",i,iavailable)
}


public ban_some_maps()
{
        new mapbfile[64]
        get_configsdir(mapbfile, 63)
        format(mapbfile, 63, "%s/map_manage/mapstoban.ini", mapbfile)
        new i=0
        new line=0
        new stextsize = 0
        new linestr[256]
        new maptext[32]

        if (file_exists(mapbfile))
        {
                while(read_file(mapbfile,line,linestr,255,stextsize)&&i<MAX_MAPS_AMOUNT)
                {
                        format(maptext,31,"%s",linestr)
                        if(is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                        {
                                banthesemaps[i++]=maptext
                        }
                        line++
                }
        }

        totalbanned=i

        if(totalbanned>0)
        {
                log_amx("%L", LANG_SERVER, "LOG_AMX_BANNED_MAP_TXT",totalbanned)
        }
        else
        {
                log_amx("%L", LANG_SERVER, "LOG_AMX_NO_BANNED_MAP_TXT")
        }

        new lmappfile[64]
        get_configsdir(lmappfile, 63)
        format(lmappfile, 63, "%s/map_manage/lastmapsplayed.txt", lmappfile)
        line=stextsize = 0
        new current_map[32]
        get_mapname(current_map,31)
        lastmaps[0]=current_map
        bannedsofar++
        currentplayers=activeplayers=rocks=0

        if (file_exists(lmappfile))
        {
                while(read_file(lmappfile,line,linestr,255,stextsize)&&bannedsofar<=ban_last_maps)
                {
                        if((strlen(linestr) > 0)&&(is_map_valid(linestr)))
                        {
                                format(lastmaps[bannedsofar++],31,"%s",linestr)
                        }
                        line++
                }
        }
}


public write_lastmaps()
{
        new lmappfile[64]
        get_configsdir(lmappfile, 63)
        format(lmappfile, 63, "%s/map_manage/lastmapsplayed.txt", lmappfile)

        if (file_exists(lmappfile))
        {
                delete_file(lmappfile)
        }

        new text[256],p

        for(p=0;p<bannedsofar;p++)
        {
                format(text,255,"%s",lastmaps[p])
                write_file(lmappfile,text)
        }

        write_file(lmappfile,"//Generated by map_nominate plugin,")
        write_file(lmappfile,"//these are most recent maps played")
}


public load_maps()
{
        new mapcfile[64]
        get_configsdir(mapcfile, 63)
        format(mapcfile, 63, "%s/map_manage/mapchoice.ini", mapcfile);
        new line=0
        new stextsize = 0 ,isinlist,unable=0, i
        new linestr[256]
        new maptext[32]
        new current_map[32]
        get_mapname(current_map,31)

        if (file_exists(mapcfile))
        {
                while( read_file(mapcfile,line,linestr,255,stextsize) && (num_nmapsfill<MAX_MAPS_AMOUNT) )
                {
                        format(maptext,31,"%s",linestr)

                        if (is_map_valid(maptext)&&!is_map_valid(maptext[1]))
                        {
                                isinlist=0

                                if(isbanned(maptext)||islastmaps(maptext))
                                {
                                        isinlist=1
                                }
                                else
                                {
                                        if (equali(maptext,current_map) || equali(maptext,last_map))
                                        {
                                                isinlist=1
                                        }
                                        else
                                        {
                                                for(i = 0; i < num_nmapsfill; i++)
                                                {
                                                        if (equali(maptext,nmapsfill[i]))
                                                        {
                                                                log_amx("%L", LANG_SERVER, "LOG_AMX_DEFINED_TWICE",maptext)
                                                                isinlist=1
                                                        }
                                                }
                                        }
                                }

                                if(!isinlist)
                                {
                                        copy(nmapsfill[num_nmapsfill++],31,maptext)
                                }
                                else
                                {
                                        unable++
                                }
                        }
                        line++
                }

                log_amx("%L", LANG_SERVER, "LOG_AMX_LOAD_PICK_VOTE",num_nmapsfill)
                log_amx("%L", LANG_SERVER, "LOG_AMX_NOT_LOAD_BAN",unable)
        }
        else
        {
                log_amx("%L", LANG_SERVER, "LOG_AMX_UNABLE_LOAD_TXT",mapcfile)
                get_listing();
        }
}


public load_defaultmaps()
{
        new smapfile[64]
        get_configsdir(smapfile, 63)
        format(smapfile, 63, "%s/map_manage/standardmaps.ini", smapfile)
        new i=0
        new line=0
        new stextsize = 0
        new linestr[256]
        new maptext[32]
        usestandard=1

        if (!file_exists(smapfile))
        {
                usestandard=standardtotal=0
        }
        else
        {
                while(read_file(smapfile,line,linestr,255,stextsize)&&i<40)
                {
                        format(maptext,31,"%s",linestr)

                        if(is_map_valid(maptext))
                        {
                                standard[i++]=maptext
                        }
                        line++
                }

                standardtotal=i
        }

        if(standardtotal<5)
        {
                usestandard=0
                log_amx("%L", LANG_SERVER, "LOG_AMX_STD_MAPS_WARN", standardtotal)
        }
}


bool:iscustommap(map[])
{
        new a

        for(a=0;a<standardtotal;a++)
        {
                if(equali(map,standard[a]))
                {
                        return false
                }
        }

        if(usestandard)
        {
                return true
        }

        return false
}


bool:islastmaps(map[])
{
        new a

        for(a=0;a<bannedsofar;a++)
        {
                if(equali(map,lastmaps[a]))
                {
                        return true
                }
        }

        return false
}


bool:isnominated(map[])
{
        new a

        for(a=0;a<nmaps_num;a++)
        {
                if(equali(map,nmaps[a]))
                {
                        return true
                }
        }

        return false
}


bool:isbanned(map[])
{
        new a

        for(a=0;a<totalbanned;a++)
        {
                if(equali(map,banthesemaps[a]))
                {
                        return true
                }
        }
        
        return false
}


loadsettings(filename[])
{
        if (!file_exists(filename))
        {
                return 0
        }

        new text[256],percent[5],strban[4],strplay[3],strwait[3],strwait2[3],strurl[64], strnum[3], strnum2[3]
        new len, pos = 0
        new Float:numpercent
        new banamount,nplayers,waittime,mapsnum

        while (read_file(filename,pos++,text,255,len))
        {
                if ( text[0] == ';' )
                {
                        continue
                }
                
                switch(text[0])
                {
                        case 'r':
                        {
                                format(percent,4,"%s",text[2])
                                numpercent=float(str_to_num(percent))/100.0

                                if(numpercent>=0.03&&numpercent<=1.0)
                                {
                                        rtvpercent=numpercent
                                }
                        }

                        case 'q':
                        {
                                if(text[1]=='2')
                                {
                                        quiet=2
                                }
                                else
                                {
                                        quiet=1
                                }
                        }
                        
                        case 'c':
                        {
                                cycle=1
                        }

                        case 'd':
                        {
                                enabled=0
                        }
                        
                        case 'f':
                        {
                                if(text[1]=='r')
                                {
                                        format(strwait2,2,"%s",text[2])
                                        waittime=str_to_num(strwait2)

                                        if(waittime>=2&&waittime<=20)
                                        {
                                                frequency=waittime
                                        }
                                }
                                else
                                {
                                        dofreeze=0
                                }
                        }

                        case 'b':
                        {
                                format(strban,3,"%s",text[2])
                                banamount=str_to_num(strban)

                                if(banamount>=0&&banamount<=100)
                                {
                                        if((banamount==0&&text[2]=='0')||banamount>0)
                                        {
                                                ban_last_maps=banamount
                                        }
                                }
                        }

                        case 'm':
                        {
                                if(atstart)
                                {
                                        format(strnum,2,"%s",text[2])
                                        mapsnum=str_to_num(strnum)

                                        if(mapsnum>=2&&mapsnum<=8)
                                        {
                                                maps_to_select=mapssave=mapsnum
                                        }
                                }
                        }
                        
                        case 'p':
                        {
                                format(strplay,2,"%s",text[2])
                                nplayers=str_to_num(strplay)

                                if(nplayers>0&&nplayers<=32)
                                {
                                        minimum=nplayers
                                }
                        }
                        
                        case 'u':
                        {
                                format(strurl,63,"%s",text[2])

                                if((containi(strurl,"www")!=-1||containi(strurl,"http")!=-1)&&!equali(strurl,"http"))
                                {
                                        mapsurl=strurl
                                }
                        }

                        case 'w':
                        {
                                format(strwait,2,"%s",text[2])
                                waittime=str_to_num(strwait)

                                if(waittime>=5&&waittime<=30)
                                {
                                        minimumwait=waittime
                                }
                        }

                        case 'x':
                        {
                                format(strnum2,2,"%s",text[2])
                                mapsnum=str_to_num(strnum2)

                                if(mapsnum>=1&&mapsnum<=3)
                                {
                                        maxnom=mapsnum
                                }
                        }
                        
                        case 'y':
                        {
                                format(strnum2,2,"%s",text[2])
                                mapsnum=str_to_num(strnum2)

                                if(mapsnum>=1&&mapsnum<=mapssave)
                                {
                                        maxcustnom=mapsnum
                                }
                        }
                }
        }

        return 1
}


set_defaults(myid)
{
        rtvpercent=0.6
        ban_last_maps=4
        maxnom=frequency=3
        quiet=cycle=0
        minimum=enabled=1
        minimumwait=10
        mapssave=maxcustnom=5
        mapsurl=""
        dofreeze=cstrike_running()

        if(myid>=0)
        {
                savesettings(myid)
        }
        else
        {
              savesettings(-1)
        }
        
        if(myid>=0)
        {
                showsettings(myid)
                console_print(myid,"%L", myid, "CONSOLE_SET_DEFAULTS")
        }
}


public dmaprtvpercent(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new Float:percentage
        percentage=float(str_to_num(arg))/100.0

        if(percentage>=0.03&&percentage<=1.0)
        {
                rtvpercent=percentage
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_RTVPCNT_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_RTVPCNT_INFO")
        }

        return PLUGIN_HANDLED
}


public dmaprtvplayers(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new players
        players=str_to_num(arg)

        if(players>=1&&players<=32)
        {
                minimum=players
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_RTVPLYR_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_RTVPLYR_INFO")
        }

        return PLUGIN_HANDLED
}


public dmaprtvwait(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new wait
        wait=str_to_num(arg)

        if(wait>=5&&wait<=30)
        {
                minimumwait=wait
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_RTVWAIT_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_RTVWAIT_INFO")
        }

        return PLUGIN_HANDLED
}


public dmapmessages(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new wait
        wait=str_to_num(arg)

        if(wait>=2&&wait<=20)
        {
                frequency=wait
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_RTVMESS_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_RTVMESS_INFO")
        }

        return PLUGIN_HANDLED
}


public dmapmapsnum(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new maps
        maps=str_to_num(arg)

        if(maps>=2&&maps<=8)
        {
                mapssave=maps
                savesettings(id)
                showsettings(id)
                console_print(id,"%L", id, "CONSOLE_MAPNUM_NEXTMAP")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_MAPSNUM_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_MAPSNUM_INFO")
        }

        return PLUGIN_HANDLED
}


public dmapmaxnominations(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new thisnumber
        thisnumber=str_to_num(arg)

        if(thisnumber>=1&&thisnumber<=3)
        {
                maxnom=thisnumber
                savesettings(id)
                showsettings(id)
                console_print(id,"%L", id, "CONSOLE_NOMNATE_NEXTMAP")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_NOMNATE_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_NOMNATE_INFO")
        }

        return PLUGIN_HANDLED
}


public dmapmaxcustom(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,3)
        new thisnumber
        thisnumber=str_to_num(arg)

        if(thisnumber>=1&&thisnumber<=mapssave)
        {
                maxcustnom=thisnumber
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_MAXCUST_BETWEEN",mapssave)
                console_print(id,"%L", id, "CONSOLE_MAXCUST_INFO")
        }

        return PLUGIN_HANDLED
}


public dmapquiet(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,31)

        if(containi(arg, "off")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_QUETMOD_OFF")
                quiet=0
        }
        else if(containi(arg, "silent")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_QUETMOD_SIL")
                quiet=2
        }
        else if(containi(arg, "nosound")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_QUETMOD_NSD")
                quiet=1
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_QUETMOD_USG")
                return PLUGIN_HANDLED
        }

        savesettings(id)
        showsettings(id)
        return PLUGIN_HANDLED
}


public dmaprtvtoggle(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        if(enabled==0)
        {
                console_print(id,"%L", id, "CONSOLE_RTVTOGG_ON")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_RTVTOGG_OFF")
        }

        enabled=!enabled
        savesettings(id)
        showsettings(id)
        return PLUGIN_HANDLED
}


public changefreeze(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }
        
        if (!cstrike_running())
        {
                console_print(id,"%L", id, "CONSOLE_FREEZE_NOCS")
                return PLUGIN_HANDLED
        }
        
        new arg[32]
        read_argv(1,arg,31)

        if(containi(arg, "off")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_FREEZE_OFF")
                dofreeze=0
        }
        else
        {
                if(containi(arg, "on")!=-1)
                {
                        console_print(id,"%L", id, "CONSOLE_FREEZE_ON")
                        dofreeze=1
                }
                else
                {
                        console_print(id,"%L", id, "CONSOLE_FREEZE_USG")
                        return PLUGIN_HANDLED
                }
        }

        savesettings(id)
        showsettings(id)
        return PLUGIN_HANDLED
}


public dmapcyclemode(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }
        
        if(!cycle)
        {
                console_print(id,"%L", id, "CONSOLE_CYCMOD_ON")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_CYCMOD_AON")
                console_print(id,"%L", id, "CONSOLE_CYCMOD_DIS")
                return PLUGIN_HANDLED
        }
        
        cycle=1
        savesettings(id)
        showsettings(id)

        if(inprogress)
        {
                console_print(id,"%L", id, "CONSOLE_VOTEP_TERM")
        }
        
        return PLUGIN_HANDLED
}


public dmapvotemode(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        if(cycle)
        {
                console_print(id,"%L", id, "CONSOLE_VOTMOD_ON")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_VOTMOD_AON")
                console_print(id,"%L", id, "CONSOLE_VOTMOD_DIS")
                return PLUGIN_HANDLED
        }

        cycle=0
        savesettings(id)
        showsettings(id)
        return PLUGIN_HANDLED
}


public dmapbanlastmaps(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[32]
        read_argv(1,arg,4)
        new banamount
        banamount=str_to_num(arg)

        if(banamount>=0&&banamount<=99)
        {
                if(banamount>ban_last_maps)
                {
                        console_print(id,"%L", id, "CONSOLE_BANMAP_ADD")
                        console_print(id,"%L", id, "CONSOLE_BANMAP_NMAP",ban_last_maps)
                }
                else
                {
                        if(banamount<ban_last_maps)
                        {
                                console_print(id,"%L", id, "CONSOLE_BANMAP_DEC")
                        }
                }

                ban_last_maps=banamount
                savesettings(id)
                showsettings(id)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_BANMAP_BETWEEN")
                console_print(id,"%L", id, "CONSOLE_BANMAP_INFO")
        }

        return PLUGIN_HANDLED
}


public dmaphelp(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                new myversion[32]
                get_cvar_string("Deags_Map_Manage",myversion,31)
                console_print(id,"%L", id, "CONSOLE_VERSION_INFO",myversion)
                console_print(id,"")

                if(cycle)
                {
                        console_print(id,"%L", id, "CONSOLE_CYCLE_MODE_ENABLED")
                        return PLUGIN_HANDLED
                }
                
                console_print(id,"%L", id, "CONSOLE_SAY_NOMINATE")
                console_print(id,"")
                console_print(id,"%L", id, "CONSOLE_SAY_NOMINATED")
                console_print(id,"%L", id, "CONSOLE_SAY_LISTMAPS")
                console_print(id,"%L", id, "CONSOLE_SAY_NUMMAPS_VOTE",maps_to_select)
                console_print(id,"%L", id, "CONSOLE_SAY_PLAYER_NOMINATE",maxnom)
                console_print(id,"%L", id, "CONSOLE_SAY_PLAYER_CUST_NOMINATE",maxcustnom)

                if(enabled)
                {
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV")
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_HEAD")
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_PCNT_MIN",floatround(rtvpercent*100.0),minimum)
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_MIN",minimumwait)
                }

                if(containi(mapsurl,"www")!=-1||containi(mapsurl,"http")!=-1)
                {
                        console_print(id,"%L", id, "CONSOLE_SAY_CUST_MAP_DL_LOC",mapsurl)
                }

                return PLUGIN_HANDLED
        }

        client_print(id,print_chat,"%L", id, "LOAD_MOTD_HELP")
        showmotdhelp(id)
        
        return PLUGIN_HANDLED
}


public gen_maphelphtml()
{
        new maphelpfile[64],text[128]
        get_configsdir(maphelpfile, 63)
        format(maphelpfile,63,"%s/map_manage/map_manage_help.txt", maphelpfile)

        if(file_exists(maphelpfile))
        {
                delete_file(maphelpfile)
        }
        
        format(text,127,"<body bgcolor=black><font color=orange>This Map Management Plugin allows easy nominations of maps for users,")
        write_file(maphelpfile,text)
        format(text,127,"and gives<br>the admins much control over the voting process.")
        write_file(maphelpfile,text)
        format(text,127,"<br><br>When in Voting mode, all the players need to do to nominate a map is say the name of it in chat.")
        write_file(maphelpfile,text)
        format(text,127,"<br>Usage of dmap_votemode/dmap_cyclemode by admins will either enable voting mode, or cycle mode.")
        write_file(maphelpfile,text)
        format(text,127,"<br>When in cycle mode, maps cannot be nominated, and the next map in the mapcycle will be the next map.")
        write_file(maphelpfile,text)
        format(text,127,"<br><br>The last (N) number of maps cannot be voted for.  To change this, use dmap_banlastmaps")
        write_file(maphelpfile,text)
        format(text,127,"<br><font color=red> For further help and description of commands, please visit</font>")
        write_file(maphelpfile,text)
        format(text,127,"<A href=http://djeyl.net/forum/index.php?showtopic=28679&st=0>the following web page</a></font></body>")
        write_file(maphelpfile,text)
}


public showmotdhelp(id)
{
        new header[80]
        new myversion[32]
        new maphelpfile[64]
        get_configsdir(maphelpfile, 63)
        format(maphelpfile,63,"%s/map_manage/map_manage_help.txt", maphelpfile)
        get_cvar_string("Deags_Map_Manage",myversion,31)
        format ( header , 79 ,"Deagles' Map Management Version %s Help",myversion )

        if(!file_exists("maphelpfile"))
        {
                gen_maphelphtml()
        }

        show_motd(id,maphelpfile,header)
}


public dmapstatus(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        showsettings(id)

        return PLUGIN_CONTINUE
}


showsettings(id)
{
        console_print(id,"%L", id, "CONSOLE_PLUGIN_STATUS")

        if(cycle)
        {
                console_print(id,"%L", id, "CONSOLE_CYCMOD_ON")
                console_print(id,"%L", id, "CONSOLE_CYCMOD_DIS")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_VOTMOD_ON")

                if(quiet==2)
                {
                        console_print(id,"%L", id, "CONSOLE_QUETMOD_SIL")
                }
                else
                {
                        if(quiet==1)
                        {
                                console_print(id,"%L", id, "CONSOLE_QUETMOD_NSD")
                        }
                        else
                        {
                                console_print(id,"%L", id, "CONSOLE_QUETMOD_OFF")
                                console_print(id,"%L", id, "CONSOLE_RTVMESS_SET",frequency)
                        }
                }
        }

        console_print(id,"%L", id, "CONSOLE_BANLAST_SET",ban_last_maps)

        if(maps_to_select!=mapssave)
        {
                console_print(id,"%L", id, "CONSOLE_MAPSNUM_SET_CHG",maps_to_select,mapssave)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_SAY_NUMMAPS_VOTE",maps_to_select)
                console_print(id,"%L", id, "CONSOLE_NOMNATE_SET",maxnom)
                console_print(id,"%L", id, "CONSOLE_SAY_PLAYER_CUST_NOMINATE",maxcustnom)
        }

        if(get_cvar_num("enforce_timelimit"))
        {
                console_print(id,"%L", id, "CONSOLE_SAY_ENFTLIMIT_ON")
                console_print(id,"%L", id, "CONSOLE_SAY_ENFTLIMIT_CHG")
        }

        if(enabled==0)
        {
                if(!get_cvar_num("mp_timelimit"))
                {
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_TLIMIT_DIS")
                }
                else
                {
                        console_print(id,"%L", id, "CONSOLE_RTVTOGG_OFF")
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_HEAD")
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_PCNT_MIN", floatround(rtvpercent*100.0),minimum)
                        console_print(id,"%L", id, "CONSOLE_SAY_RTV_COND_MIN",minimumwait)
                }
        }

        console_print(id,"%L", id, "CONSOLE_SAY_FREEZETIME_SET",dofreeze?"ENABLED":"DISABLED")

        if(!usestandard)
        {
                console_print(id,"%L", id, "CONSOLE_SAY_NO_CUSTOM_TAG")
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_SAY_CUSTOM_TAG")
        }
        
        if(containi(mapsurl,"www")!=-1||containi(mapsurl,"http")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_SAY_URL_DL_CUST",mapsurl)
        }
        else
        {
                console_print(id,"%L", id, "CONSOLE_SAY_NO_URL_DL_CUST")
        }

        console_print(id,"------------------------------------------------------------------------------------------------")
        console_print(id,"Commands     : dmap_status; dmap_cyclemode; dmap_votemode; dmap_quietmode <OFF|NOSOUND|SILENT>; ")
        console_print(id,"Commands     : dmap_banlastmaps <n>; dmap_default ; dmap_mapsurl <url>; dmap_mapsnum <n>; dmap_maxcustom <n>;")
        console_print(id,"Commands     : dmap_rtvtoggle; dmap_rtvpercent <n>; dmap_rtvplayers <n>; dmap_rtvwait <n>")
        console_print(id,"Commands     : dmap_rockthevote; dmap_freeze; dmap_nominations <n>; dmap_messages <n(minutes)>")
        console_print(id,"Cvars:         dmap_strict <0|1>, enforce_timelimit <0|1>; amx_extendmap_max <n>; amx_extendmap_step <n>")
        console_print(id,"%L", id, "CONSOLE_SAY_USE_HELP")
}


savesettings(myid)
{
        new mapvfile[64]
        get_configsdir(mapvfile, 63)
        format(mapvfile, 63, "%s/map_manage/mapvault.dat", mapvfile)
        new text[32],text2[128],percent,success=1,usedany=0
        format(text2,127,";To use comments simply use ;")

        if(!write_file(mapvfile,text2,0))
        {
                success=0
        }

        format(text2,127,";Do not modify this variables, this is used by the Nomination_style_voting plugin to save settings")

        if(!write_file(mapvfile,text2,1))
        {
                success=0
        }

        format(text2,127,";If you delete this file, defaults will be restored.")

        if(!write_file(mapvfile,text2,2))
        {
                success=0
        }

        format(text2,127,";If you make an invalid setting, that specific setting will restore to the default")

        if(!write_file(mapvfile,text2,3))
        {
                success=0
        }

        if(!enabled)
        {
                format(text,31,"d")//d for disabled
                usedany=1

                if(!write_file(mapvfile,text,14))
                {
                        success=0
                }
        }

        if(quiet!=0)
        {
                if(quiet==1)
                {
                        format(text,31,"q1")//d for disabled
                }
                else
                {
                        format(text,31,"q2")//d for disabled
                }

                usedany=1

                if(!write_file(mapvfile,text,14))
                {
                        success=0
                }
        }

        if(!dofreeze||!cstrike_running())
        {
                format(text,31,"f")

                if(!write_file(mapvfile,text,14))
                {
                        success=0
                }
        }
        
        if(cycle)
        {
                format(text,31,"c")//c for Cycle mode=on
                usedany=1

                if(!write_file(mapvfile,text,14))
                {
                        success=0
                }
        }

        percent=floatround(rtvpercent*100.0)

        if(percent>=3&&percent<=100)
        {
                format(text,31,"r %d",percent)
                usedany=1

                if(!write_file(mapvfile,text,5))
                {
                        success=0
                }
        }
        
        if(ban_last_maps>=0&&ban_last_maps<=100)
        {
                format(text,31,"b %d",ban_last_maps)
                usedany=1

                if(!write_file(mapvfile,text,6))
                {
                        success=0
                }
        }

        if(mapssave>=2&&mapssave<=8)
        {
                format(text,31,"m %d",mapssave)
                usedany=1

                if(!write_file(mapvfile,text,7))
                {
                        success=0
                }
        }

        if(maxnom>=1&&maxnom<=3)
        {
                format(text,31,"x %d",maxnom)
                usedany=1

                if(!write_file(mapvfile,text,8))
                {
                        success=0
                }
        }
        
        if(maxcustnom>=1&&maxcustnom<=mapssave)
        {
                format(text,31,"y %d",maxcustnom)
                usedany=1

                if(!write_file(mapvfile,text,9))
                {
                        success=0
                }
        }
        
        if(minimum>0&&minimum<=32)
        {
                format(text,31,"p %d",minimum)
                usedany=1

                if(!write_file(mapvfile,text,10))
                {
                        success=0
                }
        }
        
        if(minimumwait>=5&&minimumwait<=30)
        {
                format(text,31,"w %d",minimumwait)
                usedany=1

                if(!write_file(mapvfile,text,11))
                {
                        success=0
                }
        }

        if(frequency>=2&&frequency<=20)
        {
                format(text,31,"fr %d",frequency)
                usedany=1

                if(!write_file(mapvfile,text,12))
                {
                        success=0
                }
        }
        
        if(containi(mapsurl,"www")!=-1||containi(mapsurl,"http")!=-1)
        {
                format(text2,75,"u %s",mapsurl)
                usedany=1

                if(!write_file(mapvfile,text2,13))
                {
                        success=0
                }
        }
        
        if(usedany)
        {
                if(myid>=0)
                {
                        if(success)
                        {
                                console_print(myid,"%L",myid, "CONSOLE_SAY_SETTINGS_SAVE_SUCC")
                        }
                        else
                        {
                                console_print(myid,"%L",myid, "CONSOLE_SAY_SETTINGS_ERROR",mapvfile)
                        }
                }

                if(!success)
                {
                        log_amx("%L", LANG_SERVER, "LOG_AMX_SETTINGS_ERROR",mapvfile)
                        return 0
                }
        }
        else
        {
                if(myid>=0)
                {
                        console_print(myid,"%L", myid, "CONSOLE_SAY_SETTINGS_INVALID",mapvfile)
                        log_amx("%L", LANG_SERVER, "LOG_AMX_SETTINGS_INVALID",mapvfile)
                        return 0
                }
        }

        return 1
}


public dmapmapsurl(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        new arg[64]
        read_argv(1,arg,63)

        if(equali(arg,"http"))
        {
                console_print(id,"%L", id, "CONSOLE_SAY_SET_CUST_DL_URL")
                return PLUGIN_HANDLED
        }

        if(containi(arg,"www")!=-1||containi(arg,"http")!=-1)
        {
                console_print(id,"%L", id, "CONSOLE_SAY_CHG_CUST_DL_URL",arg)
                mapsurl=arg
                savesettings(id)
                showsettings(id)
        }
        else
        {
                if(containi(arg,"none")!=-1)
                {
                        console_print(id,"%L", id, "CONSOLE_SAY_DIS_CUST_DL_URL")
                        mapsurl=""
                        savesettings(id)
                        showsettings(id)
                }
                else
                {
                        console_print(id,"%L", id, "CONSOLE_SAY_ERR_CUST_DL_URL")
                }
        }

        return PLUGIN_HANDLED
}


public dmapdefaults(id)
{
        if (!(get_user_flags(id)&ADMIN_MAP))
        {
                console_print(id,"%L", id, "NO_ACCESS")
                return PLUGIN_HANDLED
        }

        set_defaults(id)
        return PLUGIN_HANDLED
}


public event_RoundStart()
{
        isbetween=0
        isbuytime=1
        set_task(10.0, "now_safe_to_vote")
}


public event_RoundEnd()
{
        isbetween=1
}


public now_safe_to_vote()
{
        isbuytime=0
}


public list_maps2()
{
        messagemaps()
}


public list_maps3()
{
        messagenominated()
}


public plugin_init()
{
        register_plugin("DeagsMapManage","2.10i","Deags")
        register_dictionary("mapmanager.txt")
        register_clcmd("say","HandleSay",0,"Say: vote mapname, nominate mapname, or just mapname to nominate a map, say: nominations")
        register_clcmd( "say rockthevote", "rock_the_vote", 0, "Rocks the Vote" )
        register_clcmd("say servermaps","list_maps",0,"Lists all maps in a window and in console")
        register_clcmd("say nextmap","say_nextmap",0,"Shows nextmap information to players")
        register_clcmd("servermaps","list_maps",0,"Lists all maps in a window and in console")
        register_concmd("dmap_help","dmaphelp",0,"Shows on-screen help information about Map Plugin")
        register_concmd("dmap_status","dmapstatus",ADMIN_MAP,"Shows settings/status/help of the map management variables")
        register_concmd("dmap_votemode","dmapvotemode",ADMIN_MAP,"Enables Voting (This is default mode)")
        register_concmd("dmap_cyclemode","dmapcyclemode",ADMIN_MAP,"Disables Voting (To restore voting use dmap_votemode)")
        register_concmd("dmap_banlastmaps","dmapbanlastmaps",ADMIN_MAP,"Bans the last <n> maps played from being voted (0-99)")
        register_concmd("dmap_quietmode","dmapquiet",ADMIN_MAP,"Usage: <OFF|nosound|silent>")
        register_concmd("dmap_freeze","changefreeze",ADMIN_MAP,"Toggles Freeze/Drop at end of round ON|off")
        register_concmd("dmap_messages","dmapmessages",ADMIN_MAP,"Sets the time interval in minutes between messages")
        register_concmd("dmap_rtvtoggle","dmaprtvtoggle",ADMIN_MAP,"Toggles on|off Ability of players to use rockthevote")
        register_concmd("dmap_rockthevote","admin_rockit",ADMIN_MAP,"(option: now) Allows admins to force a vote")
        register_concmd("dmap_rtvpercent","dmaprtvpercent",ADMIN_MAP,"Set the percent (3-100) of players for a rtv")
        register_concmd("dmap_rtvplayers","dmaprtvplayers",ADMIN_MAP,"Sets the minimum number of players needed to rockthevote")
        register_concmd("dmap_rtvwait","dmaprtvwait",ADMIN_MAP,"Sets the minimum time before rockthevote can occur (5-30)")
        register_concmd("dmap_default","dmapdefaults",ADMIN_MAP,"Will restore settings to default")
        register_concmd("dmap_mapsurl","dmapmapsurl",ADMIN_MAP,"Specify what website to get custom maps from")
        register_concmd("dmap_mapsnum","dmapmapsnum",ADMIN_MAP,"Set number of maps in next vote (will not take effect until next map")
        register_concmd("dmap_nominations","dmapmaxnominations",ADMIN_MAP,"Set maximum number of nominations for each person")
        register_concmd("dmap_maxcustom","dmapmaxcustom",ADMIN_MAP,"Set maximum number of custom nominations that may be made")

        register_logevent("event_RoundStart",2,"0=World triggered","1=Round_Start")
        register_logevent("event_RoundEnd",2,"0=World triggered","1=Round_End")
        register_event( "30" , "changeMap", "a" )
        register_cvar("rtv_percent","0.6")
        register_cvar("dmap_strict","0")
        register_cvar("enforce_timelimit","0")
        register_cvar("amx_extendmap_max","90")
        register_cvar("amx_extendmap_step","15")
        //new mod_name[32]
        //get_modname(mod_name,31)
        //mod_running = cstrike_running() ? true : false
        nmaps_num=num_nmapsfill=0

        if (cstrike_running())
        {
                register_cvar("Deags_Map_Manage", "2.10i",FCVAR_SERVER)
                register_event("TeamScore", "team_score", "a")
        }
        else
        {
                dofreeze=0
                register_cvar("Deags_Map_Manage", "2.10i")
        }

        rtvpercent=0.6
        ban_last_maps=4
        minimumwait=10
        atstart=enabled=minimum=1
        quiet=cycle=isend=0
        mapsurl=""
        set_task(3.0,"ban_some_maps")
        set_task(8.0,"write_lastmaps")
        set_task(2.0,"get_listing")
        set_task(14.0,"load_defaultmaps")
        set_task(17.0,"load_maps")
        set_task(15.0,"askfornextmap",987456,"",0,"b")
        set_task(5.0,"loopmessages",987111,"",0,"b")
        set_task(34.0,"gen_maphelphtml")
        oldtimelimit=get_cvar_float("mp_timelimit")
        get_localinfo("amx_lastmap",last_map,31)
        set_localinfo("amx_lastmap","")
        maps_to_select=mapssave=5
   
        new mapvault[128]
        get_configsdir(mapvault, 127)
        format(mapvault, 127, "%s/map_manage/mapvault.dat", mapvault)

        if(!loadsettings(mapvault))
        {
                log_amx("%L", LANG_SERVER, "CONSOLE_ERROR_MAPVAULT")
        }

        /* new dumpallmaps[128]
        * get_
        *if(!loadmaps(
        */

        atstart=0
        register_menucmd(register_menuid("Choose the next map:"),(-1^(-1<<(maps_to_select+2))),"vote_count")

        return PLUGIN_CONTINUE
}
