/*
 * Decompiled with CFR 0.152.
 */
package components.cstrike;

import components.TextComponent;
import game.cstrike.Game;
import game.cstrike.Player;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class ScoreBox
extends TextComponent {
    private Vector m_players;
    private boolean m_visible;
    private Color m_bgColor;
    private Game m_game;
    private Vector[] m_teams;

    public ScoreBox(Font f, Color c, Point p, Color bc, Vector players, Game game) {
        super(f, c, p);
        this.m_players = players;
        this.m_visible = false;
        this.m_bgColor = bc;
        this.m_game = game;
        this.m_teams = new Vector[2];
        this.m_teams[0] = new Vector();
        this.m_teams[1] = new Vector();
    }

    public void setVisibile(boolean v) {
        this.m_visible = v;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    private int getCalculateTeams() {
        int a = 4;
        this.m_teams[0].clear();
        this.m_teams[1].clear();
        int i = 0;
        while (i < this.m_players.size()) {
            Player pl = (Player)this.m_players.get(i);
            int team = pl.getTeam() - 1;
            if (team >= 0 && team < 2) {
                int z = 0;
                while (z < this.m_teams[team].size()) {
                    Player tpl = (Player)this.m_teams[team].get(z);
                    if (tpl.getKills() < pl.getKills() || tpl.getKills() == pl.getKills() && tpl.getDeaths() > pl.getDeaths()) break;
                    ++z;
                }
                this.m_teams[team].add(z, pl);
                ++a;
            }
            ++i;
        }
        return a;
    }

    public void draw(Graphics g, long time) {
        if (!this.isVisible()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int asc = fm.getAscent();
        int des = fm.getDescent();
        int allnum = this.getCalculateTeams();
        int boxheight = height * allnum;
        g.setColor(this.m_bgColor);
        g.fillRect(this.getX() - des - 230, this.getY() - asc - (boxheight >> 1), 460, boxheight);
        g.setColor(Color.BLACK);
        g.drawRect(this.getX() - des - 230, this.getY() - asc - (boxheight >> 1), 460, boxheight);
        g.setFont(this.getFont());
        int poss = 0;
        int cc = 0;
        while (cc < 2) {
            int b = cc + 1;
            Color tmc = this.m_game.getTeamColor(b);
            g.setColor(tmc);
            int he = this.getY() + poss++ * height - (boxheight >> 1);
            g.drawString(String.valueOf(this.m_game.getTeamName(b)) + " (" + this.m_teams[cc].size() + ")", this.getX() - 180, he);
            g.drawString("Kills", this.getX() + 70, he);
            g.drawString("Deaths", this.getX() + 140, he);
            int lin = this.getX() - des - 230;
            g.drawLine(lin + 4, he + des, lin + 456, he + des);
            int a = 0;
            while (a < this.m_teams[cc].size()) {
                if (((Player)this.m_teams[cc].get(a)).isState(4) && !((Player)this.m_teams[cc].get(a)).isState(16)) {
                    g.setColor(tmc);
                } else {
                    g.setColor(this.getColor());
                }
                he = this.getY() + poss++ * height - (boxheight >> 1);
                Player pl = (Player)this.m_teams[cc].get(a);
                g.drawString(pl.getName(), this.getX() - 230, he);
                g.drawString("" + pl.getKills(), this.getX() + 80, he);
                g.drawString("" + pl.getDeaths(), this.getX() + 160, he);
                ++a;
            }
            ++poss;
            ++cc;
        }
    }
}

