/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SpectatorComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class TextComponent
implements SpectatorComponent {
    private int posX;
    private int posY;
    private Font font;
    private Color color;

    protected TextComponent(Font f, Color c, Point p) {
        this.posX = p.x;
        this.posY = p.y;
        this.font = f;
        this.color = c;
    }

    protected final Font getFont() {
        return this.font;
    }

    protected final Color getColor() {
        return this.color;
    }

    protected final int getX() {
        return this.posX;
    }

    protected final int getY() {
        return this.posY;
    }

    final Rectangle calculateTextArea(String message, Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.font);
        int asc = fm.getAscent();
        int des = fm.getDescent();
        return new Rectangle(this.posX - des, this.posY - asc, fm.stringWidth(message) + (des << 1), fm.getHeight());
    }
}

