/*
 * Decompiled with CFR 0.152.
 */
package game;

public class Look {
    private short delta;
    private short diff;
    private short turned;
    private short current;
    private short angle = (short)15;
    private static final int frame_rate = 6;

    public void doMove() {
        if (this.turned < this.diff) {
            this.turned = (short)(this.turned + this.angle);
            this.current = Look.normalize((short)(this.current + this.delta));
        }
    }

    public final short getLook() {
        return this.current;
    }

    public void setLook(short nowy, boolean instant) {
        this.diff = (short)(Look.normalize(nowy) - this.current);
        if (this.diff < -180) {
            this.diff = (short)(360 + this.diff);
        }
        if (this.diff > 180) {
            this.diff = (short)(-(360 - this.diff));
        }
        if (instant) {
            this.turned = (short)Math.abs(this.diff);
            this.current = Look.normalize((short)(this.current + this.diff));
        } else {
            short udiff = (short)Math.abs(this.diff);
            this.angle = udiff <= 6 ? (short)6 : (short)(udiff / 6);
            this.turned = 0;
            if (this.diff < 0) {
                this.delta = -this.angle;
                if (this.delta < this.diff) {
                    this.delta = this.diff;
                }
            } else {
                this.delta = this.angle;
                if (this.delta > this.diff) {
                    this.delta = this.diff;
                }
            }
            this.diff = udiff;
        }
    }

    public static short normalize(short n) {
        while (n < 0) {
            n = (short)(n + 360);
        }
        while (n >= 360) {
            n = (short)(n - 360);
        }
        return n;
    }
}

