/*
 * Decompiled with CFR 0.152.
 */
package game.cstrike;

import components.ChatBox;
import components.FadeText;
import components.GameView;
import components.ItemView;
import components.LiveText;
import components.LiveTextInfo;
import components.MapView;
import components.StaticText;
import components.cstrike.GrenadeView;
import components.cstrike.PlayerView;
import components.cstrike.ScoreBox;
import engine.Spectator;
import game.cstrike.Bomb;
import game.cstrike.Grenade;
import game.cstrike.Player;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import protocol.cstrike.BombEvent;
import protocol.cstrike.ChatEvent;
import protocol.cstrike.DeathEvent;
import protocol.cstrike.GameProtocol;
import protocol.cstrike.GrenadeEvent;
import protocol.cstrike.MapEvent;
import protocol.cstrike.MsgEvent;
import protocol.cstrike.PlayerEvent;
import protocol.cstrike.RoundTimeEvent;
import protocol.cstrike.ScoreEvent;

public class Game
extends game.Game
implements GameProtocol {
    public GameView view;
    private ChatBox chatbox;
    private ChatBox deathmsg;
    private FadeText eventinfo;
    private LiveText scoreinfo;
    private LiveText timeinfo;
    private LiveText playerinfo;
    private StaticText error;
    public MapView map;
    public Vector grenades;
    private Vector playersView;
    public Bomb bomb;
    private int[] teamScore = new int[3];
    private short gameTime = 0;
    private int observed;
    private ScoreBox scorebox;
    private static final Color[] teamColor = new Color[]{new Color(200, 200, 200), new Color(255, 50, 50), new Color(50, 150, 255)};
    private static final String[] teamName = new String[]{"Unassigned", "Terrorist", "Counter-Terrorist"};
    private static final String[] weapons = new String[]{"unknown", "p228", "shield", "scout", "hegrenade", "xm1014", "c4", "mac10", "aug", "smokegrenade", "elite", "fiveseven", "ump45", "sg550", "galil", "famas", "usp", "glock18", "awp", "mp5navy", "m249", "m3", "m4a1", "tmp", "g3sg1", "flashbang", "deagle", "sg552", "ak47", "knife", "p90"};

    public Game(Spectator applet, StaticText txt) {
        this.error = txt;
        this.view = new GameView();
        this.playersView = new Vector();
        this.grenades = new Vector(32);
        int a = 0;
        while (a < 32) {
            Player player = new Player(this);
            this.players.add(player);
            PlayerView playerView = new PlayerView(player);
            this.playersView.add(playerView);
            this.view.add(playerView);
            ++a;
        }
        this.bomb = new Bomb(this);
        this.view.add(new ItemView(this.bomb));
        int b = 0;
        while (b < 32) {
            Grenade gr = new Grenade(this);
            this.grenades.add(gr);
            this.view.add(new GrenadeView(gr));
            ++b;
        }
        this.eventinfo = new FadeText(new Font("Dialog", 1, 25), new Color(250, 250, 250, 200), new Point(applet.getOrgWidth() >> 1, applet.getOrgHeight() >> 1));
        this.view.attach(this.eventinfo);
        this.deathmsg = new ChatBox(new Font("Dialog", 1, 12), new Color(250, 100, 0), new Point(20, 55), new Color(60, 80, 90, 150), 5, 3500L);
        this.view.attach(this.deathmsg);
        this.chatbox = new ChatBox(new Font("Dialog", 1, 12), new Color(200, 200, 200), new Point(100, 690), new Color(60, 80, 90, 150), 4, 4000L);
        this.view.attach(this.chatbox);
        this.scoreinfo = new LiveText(new Font("Dialog", 1, 16), new Color(255, 255, 255), new Color(60, 80, 90, 150), new Point(700, 30));
        this.view.attach(this.scoreinfo);
        this.scoreinfo.setLiveTextProvider(new LiveTextInfo(){

            public String getLiveTextData() {
                return String.valueOf(Game.this.getTeamName(1)) + " " + Game.this.getTeamScore(1) + " : " + Game.this.getTeamScore(2) + " " + Game.this.getTeamName(2);
            }
        });
        this.timeinfo = new LiveText(new Font("Dialog", 1, 16), new Color(250, 100, 0), new Color(60, 80, 90, 150), new Point(620, 30));
        this.view.attach(this.timeinfo);
        this.timeinfo.setLiveTextProvider(new LiveTextInfo(){

            public String getLiveTextData() {
                if (Game.this.gameTime < 0) {
                    return null;
                }
                int min = Game.this.gameTime / 60;
                int sec = Game.this.gameTime % 60;
                return String.valueOf(min) + ":" + (sec < 10 ? "0" : "") + sec;
            }
        });
        this.playerinfo = new LiveText(new Font("Dialog", 1, 16), new Color(200, 200, 200), new Color(60, 80, 90, 150), new Point(20, 30));
        this.view.attach(this.playerinfo);
        this.map = new MapView(applet, this.error);
        this.view.set(this.map);
        this.scorebox = new ScoreBox(new Font("Dialog", 1, 16), new Color(200, 200, 200), new Point(applet.getOrgWidth() >> 1, applet.getOrgHeight() >> 1), new Color(60, 80, 90, 150), this.players, this);
        this.view.attach(this.scorebox);
        applet.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 32) {
                    Game.this.scorebox.setVisibile(!Game.this.scorebox.isVisible());
                } else if (ke.getKeyCode() == 10) {
                    Game.this.chatbox.setVisible(!Game.this.chatbox.isVisible());
                }
            }
        });
        applet.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                Point pt = arg0.getPoint();
                boolean notfound = true;
                int en = 0;
                while (en < 32) {
                    PlayerView pl = (PlayerView)Game.this.playersView.get(en);
                    if (notfound && pl.getBounds().contains(pt) && ((Player)Game.this.players.get(Game.this.observed)).isVisible()) {
                        pl.setSelected(true);
                        Game.this.playerinfo.setLiveTextProvider((Player)Game.this.players.get(en));
                        notfound = false;
                    } else {
                        pl.setSelected(false);
                    }
                    ++en;
                }
                if (notfound) {
                    int looped = Game.this.observed;
                    boolean found = true;
                    do {
                        Game game = Game.this;
                        int n = game.observed + 1;
                        game.observed = n;
                        Game.this.observed = n % Game.this.players.size();
                        if (looped != Game.this.observed) continue;
                        found = false;
                        break;
                    } while (!((Player)Game.this.players.get(Game.this.observed)).isVisible());
                    if (found) {
                        Game.this.playerinfo.setLiveTextProvider((Player)Game.this.players.get(Game.this.observed));
                        ((PlayerView)Game.this.playersView.get(Game.this.observed)).setSelected(true);
                    }
                }
            }
        });
    }

    public String getWeaponName(int a) {
        if (a > 30 || a < 1) {
            return weapons[0];
        }
        return weapons[a];
    }

    public String getTeamName(int i) {
        return teamName[i];
    }

    public int getTeamNum() {
        return 2;
    }

    public int getTeamScore(int i) {
        return this.teamScore[i];
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public Color getTeamColor(int i) {
        return teamColor[i];
    }

    public void gamePlayer(PlayerEvent arg0) {
        byte i = arg0.getPlayerID();
        Player player = (Player)this.players.get(i);
        if (arg0.isSet((byte)4)) {
            player.setState(arg0.getState());
            if (!player.isVisible() && this.playerinfo.getLiveTextProvider() == player) {
                this.playerinfo.setLiveTextProvider(null);
                ((PlayerView)this.playersView.get(i)).setSelected(false);
            }
        }
        if (arg0.isSet((byte)2)) {
            player.setHealth(arg0.getHealth());
        }
        if (arg0.isSet((byte)1)) {
            player.setLookDir(arg0.getAngle(), player.isState(32));
            player.setMoveDest(new Point(arg0.getX(), arg0.getY()), player.isState(32));
        }
        if (arg0.isSet((byte)32)) {
            player.setName(arg0.getName());
        }
        if (arg0.isSet((byte)16)) {
            player.setTeam(arg0.getTeam());
        }
        if (arg0.isSet((byte)8)) {
            player.setDeaths(arg0.getDeaths());
            player.setKills(arg0.getKills());
        }
        if (arg0.isSet((byte)64)) {
            player.setWeapon(arg0.getWeapon());
        }
        if (arg0.isSet((byte)-128)) {
            player.setIcons(arg0.getIcons());
        }
    }

    public void gameChat(ChatEvent arg0) {
        int chattig = arg0.getPlayer();
        Player palyer = (Player)this.players.get(chattig);
        this.chatbox.add(String.valueOf(arg0.getStatus()) + " " + palyer.getName() + " :  " + arg0.getText());
    }

    public void gameMap(MapEvent arg0) {
        this.map.setMap(arg0.getMapName(), arg0.getZoom(), arg0.getRotation(), arg0.getX(), arg0.getY());
    }

    public void gameScore(ScoreEvent arg0) {
        this.teamScore[1] = arg0.getScore(1);
        this.teamScore[2] = arg0.getScore(2);
    }

    public void gameDeath(DeathEvent arg0) {
        int victim = arg0.getVictim();
        if (victim > -1) {
            Player pvict = (Player)this.players.get(victim);
            int killer = arg0.getKiller();
            if (killer > -1 && killer != victim) {
                Player pkill = (Player)this.players.get(killer);
                this.deathmsg.add(String.valueOf(pkill.getName()) + (arg0.isHeadhost() ? " headshoted " : " killed ") + pvict.getName() + " with " + arg0.getWeapon());
            } else {
                this.deathmsg.add(String.valueOf(pvict.getName()) + " made suicide");
            }
        }
    }

    public void gameMsg(MsgEvent arg0) {
        this.eventinfo.setText(arg0.getTextMsg(), 5000L);
    }

    public void gameGrenade(GrenadeEvent me) {
        Grenade gr = (Grenade)this.grenades.get(me.getIndex());
        byte state = me.getState();
        gr.setMoveDest(new Point(me.getX(), me.getY()), (state & 2) != 0);
        gr.setType(me.getType());
        gr.setState(state);
    }

    public void gameBomb(BombEvent arg0) {
        this.bomb.setOrigin(arg0.getX(), arg0.getY());
        this.bomb.setState(arg0.getState());
    }

    public void gameRoundTime(RoundTimeEvent arg0) {
        this.gameTime = arg0.getTime();
    }
}

